<?php
/**
 * Chatbot Oluşturma API
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user = getUserById($_SESSION['user_id']);
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Forbidden']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $name = $input['name'] ?? '';
    $type = $input['type'] ?? 'custom';
    $description = $input['description'] ?? '';
    $system_prompt = $input['system_prompt'] ?? '';
    $model = $input['model'] ?? 'gemini-2.0-flash';
    $temperature = $input['temperature'] ?? 0.7;
    $max_tokens = $input['max_tokens'] ?? 1000;
    
    if (empty($name) || empty($system_prompt)) {
        throw new Exception('İsim ve sistem talimatı gerekli');
    }
    
    $stmt = $pdo->prepare("
        INSERT INTO chatbots (name, type, description, system_prompt, model, temperature, max_tokens, created_by)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([
        $name,
        $type,
        $description,
        $system_prompt,
        $model,
        $temperature,
        $max_tokens,
        $_SESSION['user_id']
    ]);
    
    echo json_encode([
        'success' => true,
        'chatbot_id' => $pdo->lastInsertId()
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
