<?php
/**
 * Bilgi Bankası Dosyalarını Getir API
 */

session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $chatbot_id = $_GET['chatbot_id'] ?? 0;
    
    $stmt = $pdo->prepare("
        SELECT id, file_name, file_type, file_size, created_at
        FROM chatbot_knowledge
        WHERE chatbot_id = ?
        ORDER BY created_at DESC
    ");
    $stmt->execute([$chatbot_id]);
    $files = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'files' => $files
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
