<?php
/**
 * Chatbot Detaylarını Getir API
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $id = $_GET['id'] ?? 0;
    
    $stmt = $pdo->prepare("SELECT * FROM chatbots WHERE id = ?");
    $stmt->execute([$id]);
    $chatbot = $stmt->fetch();
    
    if (!$chatbot) {
        throw new Exception('Chatbot bulunamadı');
    }
    
    echo json_encode([
        'success' => true,
        'chatbot' => $chatbot
    ]);
    
} catch (Exception $e) {
    http_response_code(404);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
