<?php
/**
 * Chatbot Durumlarını Göster
 */

require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $stmt = $pdo->query("
        SELECT id, name, is_active, schedule_enabled, 
               schedule_start_time, schedule_end_time, schedule_days
        FROM chatbots
        ORDER BY id
    ");
    $chatbots = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'chatbots' => $chatbots,
        'current_time' => date('H:i:s'),
        'current_day' => date('w')
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
