<?php
/**
 * Chatbot Listesi API
 */

session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $stmt = $pdo->query("
        SELECT id, name, type, description, is_active
        FROM chatbots
        WHERE is_active = 1
        ORDER BY name ASC
    ");
    $chatbots = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'chatbots' => $chatbots
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
