<?php
/**
 * Chatbot Zamanlama Ayarları Kaydetme API
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user = getUserById($_SESSION['user_id']);
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Forbidden']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $id = $input['id'] ?? 0;
    $schedule_enabled = $input['schedule_enabled'] ?? false;
    $schedule_start_time = $input['schedule_start_time'] ?? null;
    $schedule_end_time = $input['schedule_end_time'] ?? null;
    $schedule_days = $input['schedule_days'] ?? null;
    
    $stmt = $pdo->prepare("
        UPDATE chatbots 
        SET schedule_enabled = ?, 
            schedule_start_time = ?, 
            schedule_end_time = ?, 
            schedule_days = ?,
            updated_at = NOW()
        WHERE id = ?
    ");
    
    $stmt->execute([
        $schedule_enabled ? 1 : 0,
        $schedule_start_time,
        $schedule_end_time,
        $schedule_days,
        $id
    ]);
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
