<?php
/**
 * Sohbete Chatbot Atama API
 */

session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $conversation_id = $input['conversation_id'] ?? 0;
    $chatbot_id = $input['chatbot_id'] ?? null;
    
    $stmt = $pdo->prepare("UPDATE conversations SET chatbot_id = ? WHERE id = ?");
    $stmt->execute([$chatbot_id, $conversation_id]);
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
