<?php
/**
 * Chatbot Sistem Talimatı Güncelleme API
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user = getUserById($_SESSION['user_id']);
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Forbidden']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $id = $input['id'] ?? 0;
    $system_prompt = $input['system_prompt'] ?? '';
    
    if (empty($system_prompt)) {
        throw new Exception('Sistem talimatı boş olamaz');
    }
    
    $stmt = $pdo->prepare("UPDATE chatbots SET system_prompt = ?, updated_at = NOW() WHERE id = ?");
    $stmt->execute([$system_prompt, $id]);
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
