<?php
/**
 * Yeni Sohbet Oluştur API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $phone = $input['phone'] ?? '';
    $name = $input['name'] ?? '';
    
    if (empty($phone)) {
        throw new Exception('Telefon numarası gerekli');
    }
    
    // Telefon numarasını formatla
    $phone = formatPhoneNumber($phone);
    
    if (!validatePhoneNumber($phone)) {
        throw new Exception('Geçersiz telefon numarası formatı');
    }
    
    // Müşteriyi bul veya oluştur
    $customer = getCustomerByPhone($phone);
    if (!$customer) {
        if (empty($name)) {
            $name = 'Bilinmeyen Müşteri';
        }
        createCustomer($name, $phone);
        $customer = getCustomerByPhone($phone);
    }
    
    // Mevcut aktif sohbet var mı kontrol et
    $existingConversation = getConversationByCustomer($customer['id']);
    if ($existingConversation) {
        echo json_encode([
            'success' => true,
            'conversation_id' => $existingConversation['id'],
            'message' => 'Mevcut sohbet bulundu'
        ]);
        exit();
    }
    
    // Yeni sohbet oluştur
    $conversationId = createConversation($customer['id'], $_SESSION['user_id']);
    
    echo json_encode([
        'success' => true,
        'conversation_id' => $conversationId,
        'message' => 'Sohbet oluşturuldu'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
