<?php
/**
 * Müşteri Bilgilerini Getir API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $customerId = $_GET['id'] ?? null;
    
    if (!$customerId) {
        throw new Exception('Müşteri ID gerekli');
    }
    
    // Müşteri bilgilerini getir
    $stmt = $pdo->prepare("SELECT * FROM customers WHERE id = ? AND status = 'active'");
    $stmt->execute([$customerId]);
    $customer = $stmt->fetch();
    
    if (!$customer) {
        throw new Exception('Müşteri bulunamadı');
    }
    
    echo json_encode([
        'success' => true,
        'customer' => $customer
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
