<?php
/**
 * Sohbet Mesajlarını Getir API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $conversationId = $_GET['conversation_id'] ?? null;
    
    if (!$conversationId) {
        throw new Exception('Sohbet ID gerekli');
    }
    
    // Sohbeti kontrol et
    $conversation = getConversationById($conversationId);
    if (!$conversation) {
        throw new Exception('Sohbet bulunamadı');
    }
    
    // Kullanıcının bu sohbeti görme yetkisi var mı?
    if ($conversation['assigned_to'] != $_SESSION['user_id']) {
        $user = getUserById($_SESSION['user_id']);
        if (!in_array($user['role'], ['admin', 'supervisor'])) {
            throw new Exception('Bu sohbeti görme yetkiniz yok');
        }
    }
    
    // Mesajları getir
    $messages = getMessagesByConversation($conversationId);
    
    // Mesajları okundu olarak işaretle
    markMessagesAsRead($conversationId, $_SESSION['user_id']);
    
    // Mesajları formatla
    $formattedMessages = [];
    foreach ($messages as $message) {
        $formattedMessages[] = [
            'id' => $message['id'],
            'content' => $message['content'],
            'sender_type' => $message['sender_type'],
            'sender_id' => $message['sender_id'],
            'is_read' => (bool)$message['is_read'],
            'created_at' => $message['created_at'],
            'time_ago' => timeAgo($message['created_at'])
        ];
    }
    
    echo json_encode([
        'success' => true,
        'conversation' => [
            'id' => $conversation['id'],
            'customer_name' => $conversation['customer_name'],
            'customer_phone' => $conversation['customer_phone'],
            'customer_email' => $conversation['customer_email'],
            'status' => $conversation['status'],
            'priority' => $conversation['priority'],
            'assigned_to' => $conversation['assigned_to'],
            'platform' => $conversation['platform'] ?? 'whatsapp',
            'is_ai_active' => (bool)$conversation['is_ai_active'],
            'chatbot_id' => $conversation['chatbot_id'],
            'customer_status' => $conversation['customer_status']
        ],
        'messages' => $formattedMessages
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
