<?php
/**
 * Get Unassigned Conversations API
 * Returns conversations that haven't been assigned to any agent
 */

header('Content-Type: application/json');
session_start();

require_once '../config/database.php';
require_once '../includes/functions.php';

// Check authentication
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];
$user = getUserById($user_id);

// Only admin and supervisor can view unassigned conversations
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Permission denied']);
    exit;
}

// Get query parameters
$platform = $_GET['platform'] ?? null;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;

try {
    $conversations = getUnassignedConversations($platform, $limit);
    
    echo json_encode([
        'success' => true,
        'count' => count($conversations),
        'conversations' => $conversations
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
