<?php
/**
 * Create WhatsApp Inbox
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

// Check auth
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user_id = $_SESSION['user_id'];
$user = getUserById($user_id);
$workspace_id = $_SESSION['workspace_id'] ?? 1;

if ($user['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Only admin can create inboxes']);
    exit();
}

try {
    $inbox_name = $_POST['inbox_name'] ?? '';
    $phone_number_id = $_POST['phone_number_id'] ?? '';
    $business_account_id = $_POST['business_account_id'] ?? '';
    $access_token = $_POST['access_token'] ?? '';
    $verify_token = $_POST['verify_token'] ?? '';
    
    if (empty($inbox_name) || empty($phone_number_id) || empty($access_token)) {
        throw new Exception('All fields are required');
    }
    
    // Create identifier from phone_number_id
    $identifier = 'wa_' . $phone_number_id;
    
    // Check if inbox already exists
    $stmt = $pdo->prepare("SELECT id FROM inboxes WHERE identifier = ?");
    $stmt->execute([$identifier]);
    if ($stmt->fetch()) {
        throw new Exception('This WhatsApp number is already connected');
    }
    
    // Create inbox
    $stmt = $pdo->prepare("
        INSERT INTO inboxes (
            workspace_id,
            name,
            channel_type,
            identifier,
            phone_number_id,
            business_account_id,
            access_token,
            verify_token,
            settings,
            is_active
        ) VALUES (?, ?, 'whatsapp', ?, ?, ?, ?, ?, ?, 1)
    ");
    
    $settings = json_encode([
        'connected_at' => date('Y-m-d H:i:s'),
        'connected_by' => $user_id
    ]);
    
    $stmt->execute([
        $workspace_id,
        $inbox_name,
        $identifier,
        $phone_number_id,
        $business_account_id,
        $access_token, // Should be encrypted in production
        $verify_token,
        $settings
    ]);
    
    $inbox_id = $pdo->lastInsertId();
    
    // Add current user as inbox member
    $stmt = $pdo->prepare("
        INSERT INTO inbox_members (inbox_id, user_id) 
        VALUES (?, ?)
    ");
    $stmt->execute([$inbox_id, $user_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'WhatsApp inbox created successfully',
        'inbox_id' => $inbox_id
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

