<?php
/**
 * Disconnect Inbox
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

// Check auth
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user = getUserById($_SESSION['user_id']);
if ($user['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Only admin can disconnect inboxes']);
    exit();
}

try {
    $data = json_decode(file_get_contents('php://input'), true);
    $inbox_id = $data['inbox_id'] ?? 0;
    
    if (empty($inbox_id)) {
        throw new Exception('Inbox ID is required');
    }
    
    // Soft delete (set is_active = 0)
    $stmt = $pdo->prepare("UPDATE inboxes SET is_active = 0, updated_at = NOW() WHERE id = ?");
    $stmt->execute([$inbox_id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Inbox disconnected successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

