<?php
/**
 * Save Facebook App Configuration
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

// Check auth
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user = getUserById($_SESSION['user_id']);
if ($user['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Only admin can update app config']);
    exit();
}

try {
    $app_id = $_POST['app_id'] ?? '';
    $app_secret = $_POST['app_secret'] ?? '';
    
    if (empty($app_id) || empty($app_secret)) {
        throw new Exception('App ID and Secret are required');
    }
    
    // Save or update app ID
    $stmt = $pdo->prepare("
        INSERT INTO settings (`key`, value) 
        VALUES ('facebook_app_id', ?)
        ON DUPLICATE KEY UPDATE value = VALUES(value)
    ");
    $stmt->execute([$app_id]);
    
    // Save or update app secret
    $stmt = $pdo->prepare("
        INSERT INTO settings (`key`, value) 
        VALUES ('facebook_app_secret', ?)
        ON DUPLICATE KEY UPDATE value = VALUES(value)
    ");
    $stmt->execute([$app_secret]);
    
    echo json_encode([
        'success' => true,
        'message' => 'App configuration saved successfully'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

