<?php
/**
 * Müşteri Kaydet API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $name = sanitizeInput($_POST['customer-name'] ?? '');
    $phone = sanitizeInput($_POST['customer-phone'] ?? '');
    $email = sanitizeInput($_POST['customer-email'] ?? '');
    $notes = sanitizeInput($_POST['customer-notes'] ?? '');
    
    if (empty($name) || empty($phone)) {
        throw new Exception('Ad ve telefon numarası gerekli');
    }
    
    // Telefon numarasını formatla
    $phone = formatPhoneNumber($phone);
    
    if (!validatePhoneNumber($phone)) {
        throw new Exception('Geçersiz telefon numarası formatı');
    }
    
    // Aynı telefon numarasına sahip müşteri var mı kontrol et
    $existingCustomer = getCustomerByPhone($phone);
    if ($existingCustomer) {
        throw new Exception('Bu telefon numarasına sahip müşteri zaten mevcut');
    }
    
    // Müşteriyi oluştur
    $stmt = $pdo->prepare("
        INSERT INTO customers (name, phone, email, notes, created_at) 
        VALUES (?, ?, ?, ?, NOW())
    ");
    $stmt->execute([$name, $phone, $email ?: null, $notes ?: null]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Müşteri başarıyla oluşturuldu'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
