<?php
/**
 * Toggle AI Status API
 */

session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$conversation_id = $input['conversation_id'] ?? null;
$is_active = $input['is_active'] ?? false;

if (!$conversation_id) {
    echo json_encode(['success' => false, 'error' => 'Missing conversation_id']);
    exit();
}

try {
    $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = ? WHERE id = ?");
    $stmt->execute([$is_active ? 1 : 0, $conversation_id]);
    
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
