<?php
/**
 * Müşteri Durumu Güncelleme API
 */

session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $conversation_id = $input['conversation_id'] ?? 0;
    $customer_status = $input['customer_status'] ?? null;
    
    // Validation
    if (!$conversation_id) {
        echo json_encode(['success' => false, 'error' => 'conversation_id gerekli']);
        exit();
    }
    
    // Boş string'i NULL'a çevir
    if ($customer_status === '') {
        $customer_status = null;
    }
    
    // Geçerli durumlar
    $valid_statuses = ['potential', 'info_received', 'positive', 'negative', 'pending', null];
    if (!in_array($customer_status, $valid_statuses)) {
        echo json_encode(['success' => false, 'error' => 'Geçersiz durum']);
        exit();
    }
    
    $stmt = $pdo->prepare("UPDATE conversations SET customer_status = ? WHERE id = ?");
    $stmt->execute([$customer_status, $conversation_id]);
    
    // Verify update
    $stmt = $pdo->prepare("SELECT customer_status FROM conversations WHERE id = ?");
    $stmt->execute([$conversation_id]);
    $result = $stmt->fetch();
    
    echo json_encode([
        'success' => true,
        'customer_status' => $result['customer_status'],
        'message' => 'Müşteri durumu güncellendi'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false, 
        'error' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
}
?>
