<?php
/**
 * Müşteri Güncelleme API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $id = $input['id'] ?? null;
    $name = $input['name'] ?? null;
    $phone = $input['phone'] ?? null;
    $email = $input['email'] ?? '';
    $notes = $input['notes'] ?? '';
    
    if (!$id || !$name || !$phone) {
        throw new Exception('ID, ad ve telefon alanları zorunludur');
    }
    
    // Telefon numarasını temizle
    $phone = preg_replace('/[^0-9+]/', '', $phone);
    
    // Müşteri var mı kontrol et
    $stmt = $pdo->prepare("SELECT id FROM customers WHERE id = ? AND status = 'active'");
    $stmt->execute([$id]);
    if (!$stmt->fetch()) {
        throw new Exception('Müşteri bulunamadı');
    }
    
    // Telefon numarası başka müşteride var mı kontrol et
    $stmt = $pdo->prepare("SELECT id FROM customers WHERE phone = ? AND id != ? AND status = 'active'");
    $stmt->execute([$phone, $id]);
    if ($stmt->fetch()) {
        throw new Exception('Bu telefon numarası başka bir müşteride kayıtlı');
    }
    
    // Müşteriyi güncelle
    $stmt = $pdo->prepare("
        UPDATE customers 
        SET name = ?, phone = ?, email = ?, notes = ?, updated_at = NOW() 
        WHERE id = ?
    ");
    
    $stmt->execute([$name, $phone, $email, $notes, $id]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Müşteri başarıyla güncellendi'
    ]);
    
    writeLog("Müşteri güncellendi - ID: " . $id . " - Kullanıcı: " . $_SESSION['user_id']);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
    
    writeLog("Müşteri güncelleme hatası: " . $e->getMessage());
}
?>
