<?php
/**
 * Update existing Facebook customers with real names
 * Run this once to update all FB-XXXXX customers
 */

require_once '../config/database.php';

// Get Facebook Page Access Token
$stmt = $pdo->prepare("SELECT value FROM settings WHERE setting_key = 'facebook_page_token'");
$stmt->execute();
$result = $stmt->fetch();
$pageToken = $result ? $result['value'] : null;

if (!$pageToken) {
    die("❌ ERROR: Facebook Page Token not found in settings!\n\nPlease add it in Settings > Facebook Integration\n");
}

echo "✅ Facebook Page Token found\n\n";

// Get all customers with FB- prefix
$stmt = $pdo->query("
    SELECT id, name, facebook_id 
    FROM customers 
    WHERE name LIKE 'FB-%' AND facebook_id IS NOT NULL
");
$customers = $stmt->fetchAll();

echo "Found " . count($customers) . " customers to update\n\n";

$updated = 0;
$failed = 0;

foreach ($customers as $customer) {
    echo "Processing: {$customer['name']} (ID: {$customer['facebook_id']})... ";
    
    // Call Facebook Graph API
    $url = "https://graph.facebook.com/v18.0/{$customer['facebook_id']}?fields=name&access_token={$pageToken}";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['name'])) {
            // Update customer name
            $updateStmt = $pdo->prepare("UPDATE customers SET name = ? WHERE id = ?");
            $updateStmt->execute([$data['name'], $customer['id']]);
            
            echo "✅ Updated to: {$data['name']}\n";
            $updated++;
        } else {
            echo "❌ No name in response\n";
            $failed++;
        }
    } else {
        echo "❌ API Error (HTTP $httpCode)\n";
        $failed++;
    }
    
    // Rate limiting - wait 100ms between requests
    usleep(100000);
}

echo "\n=================================\n";
echo "✅ Updated: $updated customers\n";
echo "❌ Failed: $failed customers\n";
echo "=================================\n";
?>
