<?php
/**
 * Simple Facebook Webhook Test
 * Minimal version to test if webhook works
 */

// Enable error logging
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/facebook_error.log');

// Create logs directory
if (!is_dir(__DIR__ . '/../logs')) {
    mkdir(__DIR__ . '/../logs', 0755, true);
}

// Log function
function logWebhook($message) {
    $logFile = __DIR__ . '/../logs/facebook_webhook_' . date('Y-m-d') . '.log';
    $logMessage = '[' . date('Y-m-d H:i:s') . '] ' . $message . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);
}

// Fetch Facebook user name from Graph API
function getFacebookUserName($sender_id) {
    try {
        require_once __DIR__ . '/../config/database.php';
        
        // Get Facebook Page Access Token from settings
        $stmt = $pdo->prepare("SELECT value FROM settings WHERE setting_key = 'facebook_page_token'");
        $stmt->execute();
        $result = $stmt->fetch();
        $pageToken = $result ? $result['value'] : null;
        
        if (!$pageToken) {
            logWebhook("ERROR: Facebook Page Token not found in settings");
            return 'FB-' . substr($sender_id, -8);
        }
        
        // Call Facebook Graph API
        $url = "https://graph.facebook.com/v18.0/{$sender_id}?fields=name&access_token={$pageToken}";
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if (isset($data['name'])) {
                logWebhook("Fetched name from Facebook: " . $data['name']);
                return $data['name'];
            }
        }
        
        logWebhook("Failed to fetch name from Facebook API. HTTP Code: $httpCode, Response: $response");
        return 'FB-' . substr($sender_id, -8);
        
    } catch (Exception $e) {
        logWebhook("ERROR fetching Facebook name: " . $e->getMessage());
        return 'FB-' . substr($sender_id, -8);
    }
}

logWebhook("=== Webhook Called ===");
logWebhook("Method: " . $_SERVER['REQUEST_METHOD']);

// GET: Webhook verification
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $mode = $_GET['hub_mode'] ?? '';
    $token = $_GET['hub_verify_token'] ?? '';
    $challenge = $_GET['hub_challenge'] ?? '';
    
    logWebhook("GET Request - Mode: $mode, Token: $token, Challenge: $challenge");
    
    // Use a simple verify token for now
    $VERIFY_TOKEN = 'multicrm_facebook_verify_2024';
    
    if ($mode === 'subscribe' && $token === $VERIFY_TOKEN) {
        logWebhook("Verification successful");
        echo $challenge;
        http_response_code(200);
    } else {
        logWebhook("Verification failed");
        http_response_code(403);
    }
    exit;
}

// POST: Handle incoming messages
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    logWebhook("POST Request received");
    logWebhook("Body: " . substr($input, 0, 500));
    
    try {
        require_once __DIR__ . '/../config/database.php';
        require_once __DIR__ . '/../includes/functions.php';
        
        $data = json_decode($input, true);
        
        if (!$data) {
            logWebhook("Invalid JSON");
            http_response_code(400);
            exit;
        }
        
        logWebhook("JSON parsed successfully");
        
        if (isset($data['entry'])) {
            foreach ($data['entry'] as $entry) {
                if (isset($entry['messaging'])) {
                    foreach ($entry['messaging'] as $msg) {
                        if (isset($msg['message']) && isset($msg['message']['text'])) {
                            $sender_id = $msg['sender']['id'] ?? 'unknown';
                            $message_text = $msg['message']['text'];
                            
                            logWebhook("Message from $sender_id: $message_text");
                            
                            // Get or create customer
                            $customer = getCustomerByFacebookId($sender_id);
                            
                            if (!$customer) {
                                // Fetch real name from Facebook Graph API
                                $userName = getFacebookUserName($sender_id);
                                
                                $customerId = createCustomer([
                                    'name' => $userName,
                                    'phone' => null,
                                    'email' => null,
                                    'facebook_id' => $sender_id,
                                    'notes' => 'Created via Facebook Messenger'
                                ]);
                                $customer = getCustomerById($customerId);
                                logWebhook("New customer created: $customerId with name: $userName");
                            }
                            
                            // Get or create conversation
                            $conversation = getConversationByCustomer($customer['id'], 'facebook');
                            
                            if (!$conversation) {
                                require_once __DIR__ . '/../includes/assignment-engine.php';
                                $engine = getAssignmentEngine();
                                
                                $conversationId = createConversation([
                                    'customer_id' => $customer['id'],
                                    'assigned_to' => 0,
                                    'status' => 'active',
                                    'platform' => 'facebook'
                                ]);
                                // 5. Otomatik atama yap
                $assignmentEngine = $engine; // Assuming $engine is the assignment engine instance
                $assignmentEngine->autoAssignConversation($conversationId, 'facebook'); // Changed to autoAssignConversation as per original code
                    
            // Zamanlama kontrolü - AI otomatik aktif/pasif et
            if (function_exists('checkAndUpdateAISchedule')) {
                checkAndUpdateAISchedule($conversationId);
            }
            
            // AI Yanıtı İşle (Google Gemini)
            if (function_exists('processAIResponse')) {
                processAIResponse($conversationId, $message_text, 'facebook'); // Use $conversationId here
            }
                
                logWebhook("Message processed successfully. Conversation ID: $conversationId"); // Changed to logWebhook
                                logWebhook("New conversation created: $conversationId");
                            }
                            
                            // Save message
                            saveMessage([
                                'conversation_id' => $conversation['id'],
                                'sender_id' => null,
                                'content' => $message_text,
                                'sender_type' => 'customer',
                                'facebook_message_id' => $msg['message']['mid'] ?? null
                            ]);
                            
                            logWebhook("Message saved successfully");
                        }
                    }
                }
            }
        }
        
        http_response_code(200);
        echo "OK";
        
    } catch (Exception $e) {
        logWebhook("ERROR: " . $e->getMessage());
        logWebhook("Stack trace: " . $e->getTraceAsString());
        http_response_code(500);
        echo "Error";
    }
    
    exit;
}

http_response_code(405);
echo "Method not allowed";
?>
