<?php
/**
 * Instagram Webhook Handler
 * Handles incoming Instagram Direct Messages
 */

// Enable error logging
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/instagram_error.log');

// Create logs directory
if (!is_dir(__DIR__ . '/../logs')) {
    mkdir(__DIR__ . '/../logs', 0755, true);
}

// Log function
function logInstagram($message) {
    $logFile = __DIR__ . '/../logs/instagram_webhook_' . date('Y-m-d') . '.log';
    $logMessage = '[' . date('Y-m-d H:i:s') . '] ' . $message . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);
}

logInstagram("=== Instagram Webhook Called ===");
logInstagram("Method: " . $_SERVER['REQUEST_METHOD']);

// GET: Webhook verification
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $mode = $_GET['hub_mode'] ?? '';
    $token = $_GET['hub_verify_token'] ?? '';
    $challenge = $_GET['hub_challenge'] ?? '';
    
    logInstagram("GET Request - Mode: $mode, Token: $token, Challenge: $challenge");
    
    // Use same verify token as WhatsApp
    $VERIFY_TOKEN = 'profaj_whatsapp_2024';
    
    if ($mode === 'subscribe' && $token === $VERIFY_TOKEN) {
        logInstagram("Verification successful");
        echo $challenge;
        http_response_code(200);
    } else {
        logInstagram("Verification failed");
        http_response_code(403);
    }
    exit;
}

// POST: Handle incoming messages
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    logInstagram("POST Request received");
    logInstagram("Body: " . substr($input, 0, 500));
    
    try {
        require_once __DIR__ . '/../config/database.php';
        require_once __DIR__ . '/../includes/functions.php';
        
        $data = json_decode($input, true);
        
        if (!$data) {
            logInstagram("Invalid JSON");
            http_response_code(400);
            exit;
        }
        
        logInstagram("JSON parsed successfully");
        
        if (isset($data['entry'])) {
            foreach ($data['entry'] as $entry) {
                // Instagram uses 'messaging' just like Facebook
                if (isset($entry['messaging'])) {
                    foreach ($entry['messaging'] as $msg) {
                        if (isset($msg['message']) && isset($msg['message']['text'])) {
                            $sender_id = $msg['sender']['id'] ?? 'unknown';
                            $message_text = $msg['message']['text'];
                            
                            logInstagram("Message from $sender_id: $message_text");
                            
                            // Get or create customer
                            $customer = getCustomerByInstagramId($sender_id);
                            
                            if (!$customer) {
                                $userName = 'IG-' . substr($sender_id, -8);
                                $customerId = createCustomer([
                                    'name' => $userName,
                                    'phone' => null,
                                    'email' => null,
                                    'instagram_id' => $sender_id,
                                    'notes' => 'Created via Instagram DM'
                                ]);
                                $customer = getCustomerById($customerId);
                                logInstagram("New customer created: $customerId");
                            }
                            
                            // Get or create conversation
                            $conversation = getConversationByCustomer($customer['id'], 'instagram');
                            
                            if (!$conversation) {
                                require_once __DIR__ . '/../includes/assignment-engine.php';
                                $engine = getAssignmentEngine();
                                
                                $conversationId = createConversation([
                                    'customer_id' => $customer['id'],
                                    'assigned_to' => 0,
                                    'status' => 'active',
                                    'platform' => 'instagram'
                                ]);
                                
                                $engine->autoAssignConversation($conversationId, 'instagram');
                                $conversation = getConversationById($conversationId);
                                
                                // 5. Otomatik atama yap
                                $assignmentEngine = getAssignmentEngine(); // Assuming getAssignmentEngine returns an instance
                                $assignmentEngine->assignConversation($conversationId, 'instagram');
                                
                                // 6. AI Yanıtı İşle (Google Gemini)
                                require_once __DIR__ . '/../includes/ai-response-processor.php';            
            // Zamanlama kontrolü - AI otomatik aktif/pasif et
            if (function_exists('checkAndUpdateAISchedule')) {
                checkAndUpdateAISchedule($conversation['id']);
            }
            
            // AI Yanıtı İşle (Google Gemini)
            if (function_exists('processAIResponse')) {
                processAIResponse($conversation['id'], $message_text, 'instagram');
            }                    
                                logInstagram("Message processed successfully. Conversation ID: $conversationId");
                                logInstagram("New conversation created: $conversationId");
                            }
                            
                            // Save message
                            saveMessage([
                                'conversation_id' => $conversation['id'],
                                'sender_id' => null,
                                'content' => $message_text,
                                'sender_type' => 'customer',
                                'instagram_message_id' => $msg['message']['mid'] ?? null
                            ]);
                            
                            logInstagram("Message saved successfully");
                        }
                    }
                }
            }
        }
        
        http_response_code(200);
        echo "OK";
        
    } catch (Exception $e) {
        logInstagram("ERROR: " . $e->getMessage());
        logInstagram("Stack trace: " . $e->getTraceAsString());
        http_response_code(500);
        echo "Error";
    }
    
    exit;
}

http_response_code(405);
echo "Method not allowed";
?>
