<?php
/**
 * WhatsApp Webhook Test Sayfası
 * Bu sayfa webhook durumunu test eder
 */

echo "<h2>WhatsApp Webhook Test</h2>";

// Webhook URL'ini test et
$webhook_url = "https://profaj.co/multicrm/api/webhook-whatsapp.php";
$test_params = [
    'hub.mode' => 'subscribe',
    'hub.verify_token' => 'profaj_whatsapp_2024',
    'hub.challenge' => 'test123'
];

$test_url = $webhook_url . '?' . http_build_query($test_params);

echo "<h3>Test URL:</h3>";
echo "<p><a href='$test_url' target='_blank'>$test_url</a></p>";

echo "<h3>Webhook Durumu:</h3>";

// Test isteği gönder
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $test_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code === 200 && $response === 'test123') {
    echo "<p style='color: green;'>✅ Webhook çalışıyor!</p>";
    echo "<p>Yanıt: $response</p>";
} else {
    echo "<p style='color: red;'>❌ Webhook hatası!</p>";
    echo "<p>HTTP Kodu: $http_code</p>";
    echo "<p>Yanıt: $response</p>";
}

echo "<h3>WhatsApp Developer Console Ayarları:</h3>";
echo "<ul>";
echo "<li><strong>Webhook URL:</strong> $webhook_url</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "<li><strong>Test URL:</strong> <a href='$test_url' target='_blank'>Test Et</a></li>";
echo "</ul>";

echo "<h3>Webhook Logları:</h3>";
$log_file = '../logs/app_' . date('Y-m-d') . '.log';
if (file_exists($log_file)) {
    $logs = file_get_contents($log_file);
    $recent_logs = array_slice(explode("\n", $logs), -10);
    echo "<pre>";
    foreach ($recent_logs as $log) {
        if (!empty(trim($log))) {
            echo htmlspecialchars($log) . "\n";
        }
    }
    echo "</pre>";
} else {
    echo "<p>Henüz log dosyası oluşturulmamış.</p>";
}
?>
