<?php
/**
 * List User Workspaces API
 * GET /api/workspaces/list.php
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/workspace.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];
$workspaces = getUserWorkspaces($user_id);

$result = [];
foreach ($workspaces as $workspace) {
    $result[] = [
        'id' => $workspace['id'],
        'name' => $workspace['name'],
        'domain' => $workspace['domain'],
        'role' => $workspace['role'],
        'is_default' => (bool)$workspace['is_default'],
        'is_current' => $workspace['id'] == $_SESSION['workspace_id']
    ];
}

echo json_encode([
    'success' => true,
    'workspaces' => $result,
    'current_workspace_id' => $_SESSION['workspace_id'] ?? null
]);
?>
