<?php
/**
 * Set Default Workspace API
 * POST /api/workspaces/set-default.php
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/workspace.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['workspace_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'workspace_id gerekli']);
    exit;
}

$workspace_id = (int)$data['workspace_id'];
$user_id = $_SESSION['user_id'];

// Set default workspace
if (setDefaultWorkspace($user_id, $workspace_id)) {
    echo json_encode([
        'success' => true,
        'message' => 'Varsayılan workspace güncellendi'
    ]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Varsayılan workspace ayarlanamadı']);
}
?>
