// AI Durumu Periyodik Kontrol
async function checkAIStatus() {
    const multiCRM = window.multiCRM;
    if (!multiCRM || !multiCRM.currentConversationId) return;

    try {
        const response = await fetch('api/chatbots/check-schedule.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                conversation_id: multiCRM.currentConversationId
            })
        });

        const data = await response.json();
        const aiToggle = document.getElementById('ai-toggle');

        if (aiToggle && data.success) {
            // AI durumunu güncelle (sadece değişmişse)
            if (data.should_be_active && !aiToggle.checked) {
                aiToggle.checked = true;
                console.log('✅ AI otomatik aktif edildi');
            } else if (!data.should_be_active && aiToggle.checked) {
                aiToggle.checked = false;
                console.log('❌ AI otomatik pasif edildi');
            }
        }
    } catch (error) {
        console.error('AI durumu kontrol hatası:', error);
    }
}

// Sayfa yüklendiğinde hemen çalıştır
setTimeout(checkAIStatus, 1000);

// Her 5 saniyede bir kontrol et
setInterval(checkAIStatus, 5000);
