<?php
/**
 * Check Database Structure
 */

session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
    die("Lütfen giriş yapın");
}

echo "<h1>Database Structure Check</h1>";

// Check agencies table structure
try {
    $stmt = $pdo->query("DESCRIBE agencies");
    $columns = $stmt->fetchAll();
    
    echo "<h2>agencies tablosu kolonları:</h2>";
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>" . $col['Field'] . "</td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "<td>" . $col['Extra'] . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    // Check if updated_at exists
    $hasUpdatedAt = false;
    foreach ($columns as $col) {
        if ($col['Field'] === 'updated_at') {
            $hasUpdatedAt = true;
            break;
        }
    }
    
    if (!$hasUpdatedAt) {
        echo "<div style='background: #ffcccc; padding: 10px; margin: 10px 0;'>";
        echo "<strong>⚠️ SORUN BULUNDU:</strong> agencies tablosunda 'updated_at' kolonu yok!";
        echo "</div>";
        
        echo "<h3>Çözüm:</h3>";
        echo "<p>Aşağıdaki SQL sorgusunu çalıştırın:</p>";
        echo "<pre style='background: #f0f0f0; padding: 10px;'>";
        echo "ALTER TABLE agencies ADD COLUMN updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;";
        echo "</pre>";
        
        echo "<form method='post'>";
        echo "<button type='submit' name='fix_column' style='background: #4CAF50; color: white; padding: 10px 20px; border: none; cursor: pointer;'>";
        echo "Otomatik Düzelt";
        echo "</button>";
        echo "</form>";
    } else {
        echo "<div style='background: #ccffcc; padding: 10px; margin: 10px 0;'>";
        echo "✅ updated_at kolonu mevcut";
        echo "</div>";
    }
    
    // Process fix request
    if (isset($_POST['fix_column'])) {
        try {
            $pdo->exec("ALTER TABLE agencies ADD COLUMN IF NOT EXISTS updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
            echo "<div style='background: #ccffcc; padding: 10px; margin: 10px 0;'>";
            echo "✅ Kolon başarıyla eklendi! Sayfayı yenileyin.";
            echo "</div>";
        } catch (Exception $e) {
            echo "<div style='background: #ffcccc; padding: 10px; margin: 10px 0;'>";
            echo "❌ Hata: " . $e->getMessage();
            echo "</div>";
        }
    }
    
} catch (Exception $e) {
    echo "<div style='background: #ffcccc; padding: 10px;'>";
    echo "Hata: " . $e->getMessage();
    echo "</div>";
}

echo "<p><a href='workspaces.php'>← Workspace Yönetimi'ne Dön</a></p>";
?>

<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    table { border-collapse: collapse; margin: 20px 0; width: 100%; }
    th { background: #333; color: white; text-align: left; }
    td, th { padding: 8px; }
    tr:nth-child(even) { background: #f9f9f9; }
</style>

