<?php
require_once 'config/database.php';

echo "📊 Facebook Messenger - Veritabanı Kontrol\n";
echo "═══════════════════════════════════════════════\n\n";

try {
    // Conversations tablosu kontrol
    $stmt = $pdo->query("SHOW COLUMNS FROM conversations LIKE 'platform'");
    $platformColumn = $stmt->fetch();
    
    if ($platformColumn) {
        echo "✅ conversations.platform sütunu MEVCUT\n";
        echo "   Tip: {$platformColumn['Type']}\n";
    } else {
        echo "❌ conversations.platform sütunu YOK\n";
    }
    
    // Customers tablosu kontrol
    $stmt = $pdo->query("SHOW COLUMNS FROM customers LIKE 'facebook_id'");
    $facebookIdColumn = $stmt->fetch();
    
    if ($facebookIdColumn) {
        echo "\n✅ customers.facebook_id sütunu MEVCUT\n";
        echo "   Tip: {$facebookIdColumn['Type']}\n";
    } else {
        echo "\n❌ customers.facebook_id sütunu YOK\n";
    }
    
    // Messages tablosu kontrol
    $stmt = $pdo->query("SHOW COLUMNS FROM messages LIKE 'platform'");
    $messagesPlatformColumn = $stmt->fetch();
    
    if ($messagesPlatformColumn) {
        echo "\n✅ messages.platform sütunu MEVCUT\n";
        echo "   Tip: {$messagesPlatformColumn['Type']}\n";
    } else {
        echo "\n❌ messages.platform sütunu YOK\n";
    }
    
    echo "\n═══════════════════════════════════════════════\n";
    
    // Sonuç
    if ($platformColumn && $facebookIdColumn && $messagesPlatformColumn) {
        echo "✅ TÜM SÜTUNLAR MEVCUT!\n";
        echo "❌ Veritabanı güncellemesi GEREKMIYOR.\n";
    } else {
        echo "⚠️  EKSIK SÜTUNLAR VAR!\n";
        echo "✅ Veritabanı güncellemesi GEREKIYOR.\n";
        echo "\nGüncelleme için:\n";
        echo "https://profaj.co/multicrm/install/database-update-wizard.php\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}
?>

