<?php
// Veritabanı bağlantı ayarları
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025',
    'charset' => 'utf8mb4'
];

// PDO veritabanı bağlantısı
try {
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['dbname']};charset={$db_config['charset']}";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
} catch (PDOException $e) {
    die("Veritabanı bağlantı hatası: " . $e->getMessage());
}

// Şifreleme fonksiyonlarını yükle
if (file_exists(__DIR__ . '/../includes/encryption.php')) {
    require_once __DIR__ . '/../includes/encryption.php';
} else {
    error_log('Encryption file not found: ' . __DIR__ . '/../includes/encryption.php');
}

/**
 * API ayarlarını veritabanından yükler
 * Fallback olarak hardcoded değerleri kullanır
 */
function loadApiSettings($pdo) {
    // WhatsApp ayarları
    $whatsapp_config = [
        'phone_number_id' => getSetting($pdo, 'whatsapp_phone_number_id', '592915763902531', false),
        'business_account_id' => getSetting($pdo, 'whatsapp_business_account_id', '1368891014268764', false),
        'access_token' => getSetting($pdo, 'whatsapp_access_token', 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e', true),
        'api_version' => getSetting($pdo, 'whatsapp_api_version', 'v18.0', false),
        'verify_token' => getSetting($pdo, 'whatsapp_verify_token', 'profaj_whatsapp_2024', false),
        'webhook_url' => getSetting($pdo, 'whatsapp_webhook_url', 'https://profaj.co/multicrm/api/webhook-whatsapp.php', false)
    ];
    
    // Facebook Messenger ayarları
    $facebook_config = [
        'app_id' => getSetting($pdo, 'facebook_app_id', '9552148291508378', false),
        'app_secret' => getSetting($pdo, 'facebook_app_secret', '88968d9ae1e845d732f9f3c3424b9d20', true),
        'page_id' => getSetting($pdo, 'facebook_page_id', '', false),
        'page_access_token' => getSetting($pdo, 'facebook_page_access_token', 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e', true),
        'api_version' => getSetting($pdo, 'facebook_api_version', 'v18.0', false),
        'verify_token' => getSetting($pdo, 'facebook_verify_token', 'profaj_whatsapp_2024', false),
        'webhook_url' => getSetting($pdo, 'facebook_webhook_url', 'https://profaj.co/multicrm/api/webhook-facebook.php', false)
    ];
    
    // Instagram ayarları (Facebook Graph API kullanır)
    $instagram_config = [
        'business_account_id' => getSetting($pdo, 'instagram_business_account_id', '', false),
        'verify_token' => getSetting($pdo, 'instagram_verify_token', 'profaj_whatsapp_2024', false),
        'webhook_url' => getSetting($pdo, 'instagram_webhook_url', 'https://profaj.co/multicrm/api/webhook-instagram.php', false)
    ];
    
    // Google AI Ayarları
    $google_ai_config = [
        'api_key' => getSetting($pdo, 'google_ai_api_key', '', true),
        'model' => getSetting($pdo, 'google_ai_model', 'gemini-pro', false),
        'system_instruction' => getSetting($pdo, 'google_ai_system_instruction', 'Sen yardımsever bir müşteri temsilcisisin.', false)
    ];
    
    return [
        'whatsapp' => $whatsapp_config,
        'facebook' => $facebook_config,
        'instagram' => $instagram_config,
        'google_ai' => $google_ai_config
    ];
}

// API ayarlarını yükle
$api_settings = loadApiSettings($pdo);
$whatsapp_config = $api_settings['whatsapp'];
$facebook_config = $api_settings['facebook'];
$instagram_config = $api_settings['instagram'];
$google_ai_config = $api_settings['google_ai'];

// WhatsApp API fonksiyonları
function sendWhatsAppMessage($to, $message, $type = 'text') {
    global $whatsapp_config;
    
    $url = "https://graph.facebook.com/{$whatsapp_config['api_version']}/{$whatsapp_config['phone_number_id']}/messages";
    
    $data = [
        'messaging_product' => 'whatsapp',
        'to' => $to,
        'type' => $type,
        'text' => ['body' => $message]
    ];
    
    $headers = [
        'Authorization: Bearer ' . $whatsapp_config['access_token'],
        'Content-Type: application/json'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'success' => $httpCode === 200,
        'response' => json_decode($response, true),
        'http_code' => $httpCode
    ];
}

// Markdown template gönderimi
function sendWhatsAppTemplate($to, $template_name, $language = 'tr', $components = []) {
    global $whatsapp_config;
    
    $url = "https://graph.facebook.com/{$whatsapp_config['api_version']}/{$whatsapp_config['phone_number_id']}/messages";
    
    $data = [
        'messaging_product' => 'whatsapp',
        'to' => $to,
        'type' => 'template',
        'template' => [
            'name' => $template_name,
            'language' => ['code' => $language],
            'components' => $components
        ]
    ];
    
    $headers = [
        'Authorization: Bearer ' . $whatsapp_config['access_token'],
        'Content-Type: application/json'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'success' => $httpCode === 200,
        'response' => json_decode($response, true),
        'http_code' => $httpCode
    ];
}

// Facebook Messenger API fonksiyonları
function sendFacebookMessage($to, $message, $type = 'text') {
    global $facebook_config;
    
    $url = "https://graph.facebook.com/{$facebook_config['api_version']}/me/messages";
    
    $data = [
        'recipient' => ['id' => $to],
        'message' => ['text' => $message]
    ];
    
    $headers = [
        'Authorization: Bearer ' . $facebook_config['page_access_token'],
        'Content-Type: application/json'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'success' => $httpCode === 200,
        'response' => json_decode($response, true),
        'http_code' => $httpCode
    ];
}
?>
