<?php
/**
 * Müşteri Bilgileri Sayfası - Gelişmiş Filtreleme
 */

session_start();
require_once 'config/database.php';
require_once 'includes/functions.php';
require_once 'includes/workspace.php';

// Giriş kontrolü
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user = getUserById($_SESSION['user_id']);
$page_title = 'Müşteri Bilgileri';

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
?>

<div class="main-content">
    <div class="container-fluid" style="padding: 20px;">
        <!-- Page Header -->
        <div class="page-header-mini" style="margin-bottom: 30px;">
            <h2 style="margin: 0; display: flex; align-items: center; gap: 12px;">
                <i class="fas fa-users"></i>
                <span>Müşteri Bilgileri</span>
            </h2>
        </div>

        <!-- Filter Panel -->
        <div class="card" style="margin-bottom: 20px;">
            <div class="card-body">
                <div style="display: flex; gap: 10px; flex-wrap: wrap; align-items: center;">
                    <h6 style="margin: 0; display: flex; align-items: center; gap: 12px;">
                        <i class="fas fa-filter"></i> Filtreler
                    </h6>
                    
                    <select id="status-filter" class="form-select" style="width: 180px;">
                        <option value="">Tüm Durumlar</option>
                        <option value="potential">Potansiyel</option>
                        <option value="info_received">Bilgi Alındı</option>
                        <option value="positive">Pozitif</option>
                        <option value="negative">Negatif</option>
                        <option value="pending">Beklemede</option>
                    </select>

                    <select id="platform-filter" class="form-select" style="width: 180px;">
                        <option value="">Tüm Platformlar</option>
                        <option value="whatsapp">WhatsApp</option>
                        <option value="facebook">Facebook</option>
                        <option value="instagram">Instagram</option>
                    </select>

                    <select id="agent-filter" class="form-select" style="width: 180px;">
                        <option value="">Tüm Ajanlar</option>
                        <?php
                        $stmt = $pdo->query("SELECT id, name FROM users WHERE role IN ('agent', 'supervisor', 'admin') ORDER BY name");
                        while ($agent = $stmt->fetch()) {
                            echo "<option value='{$agent['id']}'>{$agent['name']}</option>";
                        }
                        ?>
                    </select>

                    <input type="date" id="date-from" class="form-control" style="width: 160px;">
                    <input type="date" id="date-to" class="form-control" style="width: 160px;">

                    <button class="btn btn-primary" onclick="applyFilters()">
                        <i class="fas fa-search"></i> Filtrele
                    </button>
                    <button class="btn btn-secondary" onclick="clearFilters()">
                        <i class="fas fa-times"></i> Temizle
                    </button>
                </div>
            </div>
        </div>

        <!-- Customer Table -->
        <div class="card">
            <div class="card-body" style="padding: 0;">
                <table class="table table-hover" style="margin-bottom: 0;">
                    <thead style="background: #f8f9fa; border-bottom: 2px solid #dee2e6;">
                        <tr>
                            <th style="padding: 15px;">Müşteri</th>
                            <th style="padding: 15px;">Platform</th>
                            <th style="padding: 15px;">Durum</th>
                            <th style="padding: 15px;">Atanan Ajan</th>
                            <th style="padding: 15px;">Son Mesaj</th>
                            <th style="padding: 15px;">Toplam Mesaj</th>
                        </tr>
                    </thead>
                    <tbody id="customer-table-body">
                        <tr>
                            <td colspan="6" class="text-center" style="padding: 40px;">
                                <i class="fas fa-spinner fa-spin"></i> Yükleniyor...
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Pagination -->
        <div class="pagination" id="pagination" style="margin-top: 20px;"></div>
    </div>
</div>

<!-- Customer Detail Modal -->
<div id="customer-modal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeCustomerModal()">&times;</span>
        <h2 id="modal-customer-name"></h2>
        <div id="modal-customer-details"></div>
    </div>
</div>

<style>
/* Icon Sizing */
h2 i.fas, h6 i.fas {
    font-size: 18px;
    vertical-align: middle;
}

h2 {
    line-height: 1.2;
}

h6 {
    line-height: 1.4;
}

/* Platform Badges */
.platform-badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 500;
}

.platform-whatsapp { background: #25D366; color: white; }
.platform-facebook { background: #1877F2; color: white; }
.platform-instagram { background: #E4405F; color: white; }

/* Status Badges */
.status-badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 500;
}

.status-potential { background: #ffc107; color: #000; }
.status-info_received { background: #17a2b8; color: white; }
.status-positive { background: #28a745; color: white; }
.status-negative { background: #dc3545; color: white; }
.status-pending { background: #6c757d; color: white; }

/* Pagination */
.pagination {
    display: flex;
    justify-content: center;
    gap: 5px;
}

.pagination button {
    padding: 8px 12px;
    border: 1px solid #ddd;
    background: white;
    cursor: pointer;
    border-radius: 4px;
}

.pagination button:hover {
    background: #f8f9fa;
}

.pagination button.active {
    background: #007bff;
    color: white;
    border-color: #007bff;
}
</style>

<script src="assets/js/customer-info.js"></script>

<?php require_once 'includes/footer.php'; ?>
