<?php
header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔍 FACEBOOK MESSENGER WEBHOOK DEBUG\n";
echo "═══════════════════════════════════════════════════════════\n\n";

// 1. Config kontrol
echo "1️⃣  CONFIG KONTROLÜ:\n";
echo "───────────────────────────────────────────────────────────\n";

if (file_exists('config/facebook.php')) {
    require_once 'config/facebook.php';
    echo "✅ config/facebook.php dosyası mevcut\n";
    
    if (isset($facebook_config)) {
        echo "✅ \$facebook_config tanımlı\n";
        echo "   - App ID: " . (isset($facebook_config['app_id']) ? '✅ Var' : '❌ Yok') . "\n";
        echo "   - App Secret: " . (isset($facebook_config['app_secret']) ? '✅ Var' : '❌ Yok') . "\n";
        echo "   - Page Access Token: " . (isset($facebook_config['page_access_token']) ? '✅ Var' : '❌ Yok') . "\n";
        echo "   - Verify Token: " . (isset($facebook_config['verify_token']) ? $facebook_config['verify_token'] : '❌ Yok') . "\n";
        echo "   - Webhook URL: " . (isset($facebook_config['webhook_url']) ? $facebook_config['webhook_url'] : '❌ Yok') . "\n";
    } else {
        echo "❌ \$facebook_config tanımlı değil\n";
    }
} else {
    echo "❌ config/facebook.php dosyası bulunamadı\n";
}

echo "\n2️⃣  WEBHOOK DOSYASI KONTROLÜ:\n";
echo "───────────────────────────────────────────────────────────\n";

if (file_exists('api/webhook-facebook.php')) {
    echo "✅ api/webhook-facebook.php dosyası mevcut\n";
    $perms = substr(sprintf('%o', fileperms('api/webhook-facebook.php')), -4);
    echo "   İzinler: $perms\n";
} else {
    echo "❌ api/webhook-facebook.php dosyası bulunamadı\n";
}

echo "\n3️⃣  LOG KLASÖRÜ KONTROLÜ:\n";
echo "───────────────────────────────────────────────────────────\n";

if (is_dir('logs')) {
    echo "✅ logs/ klasörü mevcut\n";
    $perms = substr(sprintf('%o', fileperms('logs')), -4);
    echo "   İzinler: $perms\n";
    
    if (is_writable('logs')) {
        echo "✅ logs/ klasörü yazılabilir\n";
    } else {
        echo "❌ logs/ klasörü yazılabilir değil!\n";
    }
    
    // Log dosyalarını listele
    $logFiles = glob('logs/facebook_webhook_*.log');
    if (!empty($logFiles)) {
        echo "   Mevcut log dosyaları: " . count($logFiles) . " adet\n";
        rsort($logFiles);
        foreach (array_slice($logFiles, 0, 3) as $file) {
            $date = basename($file, '.log');
            $date = str_replace('facebook_webhook_', '', $date);
            $size = number_format(filesize($file) / 1024, 2);
            echo "   - $date ($size KB)\n";
        }
    } else {
        echo "   ⚠️  Hiç log dosyası yok (webhook çağrısı gelmemiş)\n";
    }
} else {
    echo "❌ logs/ klasörü bulunamadı\n";
}

echo "\n4️⃣  WEBHOOK TEST:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "Webhook URL:\n";
echo "https://profaj.co/multicrm/api/webhook-facebook.php\n\n";

echo "Doğrulama URL'i:\n";
echo "https://profaj.co/multicrm/api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=test123\n\n";

echo "Beklenen sonuç: test123\n";

echo "\n5️⃣  FACEBOOK DEVELOPER CONSOLE KONTROL LİSTESİ:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "□ Messenger ürünü eklendi mi?\n";
echo "□ Webhook URL eklendi mi?\n";
echo "□ Webhook doğrulandı mı? (yeşil tik var mı?)\n";
echo "□ Subscribe fields seçildi mi?\n";
echo "   □ messages\n";
echo "   □ messaging_postbacks\n";
echo "   □ message_deliveries\n";
echo "   □ message_reads\n";
echo "□ Sayfa subscribe edildi mi?\n";
echo "□ Page Access Token alındı mı?\n";
echo "□ Token config dosyasına eklendi mi?\n";

echo "\n6️⃣  TEST ADIMLARI:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "1. Facebook Developer Console → Webhooks bölümüne git\n";
echo "2. 'Test' butonuna tıkla\n";
echo "3. 'messages' event'ini seç\n";
echo "4. 'Send to My Server' tıkla\n";
echo "5. Sonra bu sayfayı yenile:\n";
echo "   https://profaj.co/multicrm/view-facebook-logs.php\n";

echo "\n7️⃣  OLASI SORUNLAR:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "❌ Webhook URL yanlış girilmiş\n";
echo "❌ Verify Token eşleşmiyor\n";
echo "❌ Subscribe fields seçilmemiş\n";
echo "❌ Sayfa subscribe edilmemiş\n";
echo "❌ Uygulama Development modunda ve siz page admin değilsiniz\n";
echo "❌ SSL sertifikası sorunu\n";
echo "❌ Sunucu Facebook'tan gelen istekleri engelliyor\n";

echo "\n═══════════════════════════════════════════════════════════\n";
echo "📝 SONRAKİ ADIM:\n";
echo "═══════════════════════════════════════════════════════════\n";
echo "Facebook Developer Console'da 'Test' butonunu kullan\n";
echo "ve sonucu bana bildir!\n";
echo "═══════════════════════════════════════════════════════════\n";
?>

