<?php
/**
 * Simple Inboxes Page - Debug Version
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

echo "<h1>Debug Info</h1>";
echo "<pre>";
echo "Session User ID: " . ($_SESSION['user_id'] ?? 'NOT SET') . "\n";
echo "Session Workspace ID: " . ($_SESSION['workspace_id'] ?? 'NOT SET') . "\n";
echo "PHP Version: " . PHP_VERSION . "\n";
echo "</pre>";

try {
    echo "<h2>Loading database.php...</h2>";
    require_once 'config/database.php';
    echo "✅ Database loaded<br>";
    
    echo "<h2>Loading functions.php...</h2>";
    require_once 'includes/functions.php';
    echo "✅ Functions loaded<br>";
    
    if (!isset($_SESSION['user_id'])) {
        echo "<h2>❌ Not logged in</h2>";
        echo '<a href="login.php">Go to Login</a>';
        exit();
    }
    
    echo "<h2>Getting user info...</h2>";
    $user = getUserById($_SESSION['user_id']);
    
    if (!$user) {
        echo "❌ User not found<br>";
        exit();
    }
    
    echo "✅ User found: " . htmlspecialchars($user['name']) . " (" . $user['role'] . ")<br>";
    
    if ($user['role'] !== 'admin') {
        echo "<h2>❌ Only admins can access inboxes page</h2>";
        echo '<a href="index.php">Go to Dashboard</a>';
        exit();
    }
    
    echo "<h2>Checking if inboxes table exists...</h2>";
    $stmt = $pdo->query("SHOW TABLES LIKE 'inboxes'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Inboxes table exists<br>";
        
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM inboxes");
        $count = $stmt->fetch()['count'];
        echo "📊 Total inboxes: {$count}<br>";
    } else {
        echo "⚠️ Inboxes table does NOT exist<br>";
        echo "You need to run migration: <a href='install/setup-multi-tenant.php'>Run Migration</a><br>";
    }
    
    echo "<h2>✅ All checks passed!</h2>";
    echo '<a href="inboxes.php">Try opening inboxes.php again</a>';
    
} catch (Exception $e) {
    echo "<h2>❌ Error:</h2>";
    echo "<pre style='color: red;'>";
    echo htmlspecialchars($e->getMessage());
    echo "\n\nStack Trace:\n";
    echo htmlspecialchars($e->getTraceAsString());
    echo "</pre>";
}

