<?php
/**
 * AI Durumu Debug Script
 */

session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';

echo "<h2>AI Durumu Debug</h2>";
echo "<p><strong>Şu anki saat:</strong> " . date('H:i:s') . " (Türkiye)</p>";
echo "<p><strong>Şu anki gün:</strong> " . date('w') . " (0=Pazar, 1=Pzt, ..., 6=Cmt)</p>";

// 1. Aktif chatbot var mı?
echo "<h3>1. Aktif Chatbot Kontrolü</h3>";
$stmt = $pdo->query("SELECT * FROM chatbots WHERE is_active = 1");
$active_chatbot = $stmt->fetch();

if ($active_chatbot) {
    echo "<p style='color: green;'>✅ Aktif chatbot bulundu: <strong>{$active_chatbot['name']}</strong></p>";
    echo "<pre>";
    print_r($active_chatbot);
    echo "</pre>";
} else {
    echo "<p style='color: red;'>❌ Aktif chatbot YOK! Chatbot AI sayfasında bir chatbot'u aktif yapın.</p>";
}

// 2. Son 5 sohbet
echo "<h3>2. Son Sohbetler</h3>";
$stmt = $pdo->query("
    SELECT c.id, c.customer_id, c.chatbot_id, c.is_ai_active, 
           cust.name as customer_name, cb.name as chatbot_name
    FROM conversations c
    LEFT JOIN customers cust ON c.customer_id = cust.id
    LEFT JOIN chatbots cb ON c.chatbot_id = cb.id
    ORDER BY c.created_at DESC
    LIMIT 5
");
$conversations = $stmt->fetchAll();

echo "<table border='1' cellpadding='10'>";
echo "<tr><th>ID</th><th>Müşteri</th><th>Chatbot</th><th>AI Aktif</th><th>Test</th></tr>";
foreach ($conversations as $conv) {
    $ai_status = $conv['is_ai_active'] ? '✅ Aktif' : '❌ Pasif';
    $chatbot_name = $conv['chatbot_name'] ?? '(Atanmamış)';
    echo "<tr>";
    echo "<td>{$conv['id']}</td>";
    echo "<td>{$conv['customer_name']}</td>";
    echo "<td>{$chatbot_name}</td>";
    echo "<td>{$ai_status}</td>";
    echo "<td><a href='?test_conv={$conv['id']}'>Test Et</a></td>";
    echo "</tr>";
}
echo "</table>";

// 3. Test conversation
if (isset($_GET['test_conv'])) {
    $test_conv_id = $_GET['test_conv'];
    echo "<hr>";
    echo "<h3>3. Conversation #{$test_conv_id} Test</h3>";
    
    // check-schedule.php simülasyonu
    $stmt = $pdo->prepare("
        SELECT c.chatbot_id, c.is_ai_active, cb.schedule_enabled, cb.schedule_start_time, 
               cb.schedule_end_time, cb.schedule_days, cb.name as chatbot_name
        FROM conversations c
        LEFT JOIN chatbots cb ON c.chatbot_id = cb.id
        WHERE c.id = ?
    ");
    $stmt->execute([$test_conv_id]);
    $data = $stmt->fetch();
    
    if (!$data) {
        echo "<p style='color: red;'>❌ Sohbet bulunamadı!</p>";
    } else {
        echo "<h4>Sohbet Bilgileri:</h4>";
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        
        if (!$data['chatbot_id']) {
            echo "<p style='color: orange;'>⚠️ Bu sohbete chatbot atanmamış!</p>";
            
            if ($active_chatbot) {
                echo "<p><a href='?test_conv={$test_conv_id}&assign=1'>Aktif Chatbot'u Ata</a></p>";
                
                if (isset($_GET['assign'])) {
                    $stmt = $pdo->prepare("UPDATE conversations SET chatbot_id = ? WHERE id = ?");
                    $stmt->execute([$active_chatbot['id'], $test_conv_id]);
                    echo "<p style='color: green;'>✅ Chatbot atandı! Sayfayı yenileyin.</p>";
                }
            }
        } else {
            // Chatbot var, aktif mi?
            $stmt = $pdo->prepare("SELECT is_active FROM chatbots WHERE id = ?");
            $stmt->execute([$data['chatbot_id']]);
            $cb = $stmt->fetch();
            
            if (!$cb || !$cb['is_active']) {
                echo "<p style='color: red;'>❌ Atanmış chatbot PASIF!</p>";
            } else {
                echo "<p style='color: green;'>✅ Atanmış chatbot AKTİF</p>";
                
                // Zamanlama kontrolü
                if (!$data['schedule_enabled']) {
                    echo "<p style='color: green;'>✅ Zamanlama YOK - AI her zaman aktif olmalı</p>";
                    echo "<p><strong>Sonuç:</strong> AI AKTİF olmalı!</p>";
                } else {
                    echo "<p style='color: blue;'>📅 Zamanlama AKTİF</p>";
                    echo "<p><strong>Başlangıç:</strong> {$data['schedule_start_time']}</p>";
                    echo "<p><strong>Bitiş:</strong> {$data['schedule_end_time']}</p>";
                    echo "<p><strong>Günler:</strong> {$data['schedule_days']}</p>";
                    
                    date_default_timezone_set('Europe/Istanbul');
                    $current_time = date('H:i:s');
                    $current_day = date('w');
                    
                    // Gün kontrolü
                    $active_days = explode(',', $data['schedule_days']);
                    $is_active_day = in_array($current_day, $active_days);
                    
                    echo "<p><strong>Bugün aktif mi:</strong> " . ($is_active_day ? '✅ Evet' : '❌ Hayır') . "</p>";
                    
                    // Saat kontrolü
                    $start = $data['schedule_start_time'];
                    $end = $data['schedule_end_time'];
                    
                    if ($start > $end) {
                        $is_within_time = ($current_time >= $start || $current_time < $end);
                        echo "<p><strong>Gece geçişi modu</strong></p>";
                    } else {
                        $is_within_time = ($current_time >= $start && $current_time < $end);
                        echo "<p><strong>Normal aralık modu</strong></p>";
                    }
                    
                    echo "<p><strong>Saat aralığında mı:</strong> " . ($is_within_time ? '✅ Evet' : '❌ Hayır') . "</p>";
                    
                    $should_be_active = ($is_active_day && $is_within_time);
                    
                    if ($should_be_active) {
                        echo "<p style='color: green; font-size: 18px;'><strong>✅ SONUÇ: AI AKTİF OLMALI!</strong></p>";
                    } else {
                        echo "<p style='color: red; font-size: 18px;'><strong>❌ SONUÇ: AI PASİF OLMALI!</strong></p>";
                    }
                }
            }
        }
    }
}

echo "<hr>";
echo "<h3>Sorun Giderme Adımları:</h3>";
echo "<ol>";
echo "<li>Chatbot AI sayfasında bir chatbot'u <strong>AKTİF</strong> yapın</li>";
echo "<li>Zamanlama ayarlarını kontrol edin (00:00-23:59 tüm gün için)</li>";
echo "<li>Bugünün gününü seçin</li>";
echo "<li>Yukarıdaki tablodan bir sohbet seçip <strong>Test Et</strong> tıklayın</li>";
echo "<li>Chatbot atanmamışsa <strong>Aktif Chatbot'u Ata</strong> tıklayın</li>";
echo "</ol>";
?>
