<?php
require_once '../config/database.php';

echo "<h2>Conversations Tablosu Kolonları</h2>";

try {
    $stmt = $pdo->query("DESCRIBE conversations");
    $columns = $stmt->fetchAll();
    
    echo "<table border='1' cellpadding='10'>";
    echo "<tr><th>Kolon</th><th>Tip</th><th>Null</th><th>Default</th></tr>";
    
    $has_customer_status = false;
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
        
        if ($col['Field'] === 'customer_status') {
            $has_customer_status = true;
        }
    }
    echo "</table>";
    
    if ($has_customer_status) {
        echo "<p style='color: green;'>✅ customer_status kolonu VAR</p>";
    } else {
        echo "<p style='color: red;'>❌ customer_status kolonu YOK - Eklenecek!</p>";
        echo "<p><a href='../install/add-customer-status.php'>Kolonu Ekle</a></p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Hata: " . $e->getMessage() . "</p>";
}
?>
