<?php
/**
 * AI Zamanlama Debug Script
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

echo "<h2>AI Zamanlama Debug</h2>";

// Test conversation ID'si al
$conversation_id = $_GET['conv_id'] ?? null;

if (!$conversation_id) {
    echo "<p style='color: red;'>Kullanım: debug-ai-schedule.php?conv_id=CONVERSATION_ID</p>";
    
    // Son 5 conversation'ı göster
    $stmt = $pdo->query("SELECT id, customer_id, chatbot_id, is_ai_active FROM conversations ORDER BY created_at DESC LIMIT 5");
    $convs = $stmt->fetchAll();
    
    echo "<h3>Son Sohbetler:</h3>";
    echo "<ul>";
    foreach ($convs as $conv) {
        echo "<li><a href='?conv_id={$conv['id']}'>Conversation #{$conv['id']}</a> - Chatbot: {$conv['chatbot_id']} - AI: " . ($conv['is_ai_active'] ? 'Aktif' : 'Pasif') . "</li>";
    }
    echo "</ul>";
    exit();
}

echo "<h3>Conversation ID: $conversation_id</h3>";

// 1. Conversation bilgisi
$stmt = $pdo->prepare("SELECT * FROM conversations WHERE id = ?");
$stmt->execute([$conversation_id]);
$conv = $stmt->fetch();

echo "<h4>1. Sohbet Bilgileri:</h4>";
echo "<pre>";
print_r($conv);
echo "</pre>";

// 2. Chatbot bilgisi
if ($conv['chatbot_id']) {
    $stmt = $pdo->prepare("SELECT * FROM chatbots WHERE id = ?");
    $stmt->execute([$conv['chatbot_id']]);
    $chatbot = $stmt->fetch();
    
    echo "<h4>2. Chatbot Bilgileri:</h4>";
    echo "<pre>";
    print_r($chatbot);
    echo "</pre>";
} else {
    echo "<p style='color: orange;'>⚠️ Bu sohbete chatbot atanmamış!</p>";
}

// 3. Aktif chatbot kontrolü
$stmt = $pdo->query("SELECT * FROM chatbots WHERE is_active = 1");
$activeChatbot = $stmt->fetch();

echo "<h4>3. Aktif Chatbot:</h4>";
if ($activeChatbot) {
    echo "<pre>";
    print_r($activeChatbot);
    echo "</pre>";
} else {
    echo "<p style='color: red;'>❌ Aktif chatbot yok!</p>";
}

// 4. Zamanlama kontrolü
echo "<h4>4. Zamanlama Kontrolü:</h4>";

date_default_timezone_set('Europe/Istanbul');
$current_time = date('H:i:s');
$current_day = date('w');

echo "<p><strong>Şu anki saat:</strong> $current_time</p>";
echo "<p><strong>Şu anki gün:</strong> $current_day (0=Pazar, 1=Pzt, ..., 6=Cmt)</p>";

if ($activeChatbot && $activeChatbot['schedule_enabled']) {
    echo "<p style='color: green;'>✅ Zamanlama aktif</p>";
    echo "<p><strong>Başlangıç:</strong> {$activeChatbot['schedule_start_time']}</p>";
    echo "<p><strong>Bitiş:</strong> {$activeChatbot['schedule_end_time']}</p>";
    echo "<p><strong>Aktif Günler:</strong> {$activeChatbot['schedule_days']}</p>";
    
    // Gün kontrolü
    $active_days = explode(',', $activeChatbot['schedule_days']);
    if (in_array($current_day, $active_days)) {
        echo "<p style='color: green;'>✅ Bugün aktif günlerden biri</p>";
    } else {
        echo "<p style='color: red;'>❌ Bugün aktif günlerden değil</p>";
    }
    
    // Saat kontrolü
    $start = $activeChatbot['schedule_start_time'];
    $end = $activeChatbot['schedule_end_time'];
    
    if ($start > $end) {
        // Gece geçişi
        $within = ($current_time >= $start || $current_time < $end);
        echo "<p><strong>Gece geçişi modu</strong></p>";
    } else {
        $within = ($current_time >= $start && $current_time < $end);
        echo "<p><strong>Normal aralık modu</strong></p>";
    }
    
    if ($within) {
        echo "<p style='color: green;'>✅ Şu an zamanlama aralığında</p>";
    } else {
        echo "<p style='color: red;'>❌ Şu an zamanlama aralığında DEĞİL</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Zamanlama aktif değil</p>";
}

// 5. shouldAutoActivateAI fonksiyonu test
echo "<h4>5. shouldAutoActivateAI() Testi:</h4>";

if (function_exists('shouldAutoActivateAI')) {
    $result = shouldAutoActivateAI($conversation_id);
    if ($result) {
        echo "<p style='color: green;'>✅ AI otomatik aktif edilmeli!</p>";
        
        // Manuel aktif et
        if (isset($_GET['activate'])) {
            $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 1 WHERE id = ?");
            $stmt->execute([$conversation_id]);
            echo "<p style='color: green;'>✅ AI manuel olarak aktif edildi!</p>";
        } else {
            echo "<p><a href='?conv_id=$conversation_id&activate=1' class='btn btn-primary'>Manuel Aktif Et</a></p>";
        }
    } else {
        echo "<p style='color: red;'>❌ AI otomatik aktif edilmemeli (şartlar sağlanmıyor)</p>";
    }
} else {
    echo "<p style='color: red;'>❌ shouldAutoActivateAI() fonksiyonu bulunamadı!</p>";
}

// 6. Sorun giderme önerileri
echo "<h4>6. Sorun Giderme:</h4>";
echo "<ol>";
echo "<li>Chatbot AI sayfasında bir chatbot'u <strong>aktif</strong> yapın</li>";
echo "<li>Aktif chatbot'un <strong>zamanlama ayarlarını</strong> yapın</li>";
echo "<li>Sohbete <strong>chatbot atayın</strong> (chat header'daki dropdown'dan)</li>";
echo "<li>Saatin ve günün <strong>zamanlama aralığında</strong> olduğundan emin olun</li>";
echo "</ol>";
?>
