<?php
/**
 * Basit Check-Schedule Test
 */

session_start();

// Fake session for test
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1; // Test için
}

header('Content-Type: application/json');

echo "Testing check-schedule.php...\n\n";

// Test 1: Config yükleme
echo "1. Config yükleme testi:\n";
try {
    require_once '../config/database.php';
    echo "✅ database.php yüklendi\n";
} catch (Exception $e) {
    echo "❌ database.php hatası: " . $e->getMessage() . "\n";
    exit();
}

try {
    require_once '../includes/functions.php';
    echo "✅ functions.php yüklendi\n";
} catch (Exception $e) {
    echo "❌ functions.php hatası: " . $e->getMessage() . "\n";
    exit();
}

// Test 2: Database bağlantısı
echo "\n2. Database bağlantı testi:\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM chatbots");
    $count = $stmt->fetchColumn();
    echo "✅ Database bağlantısı OK - $count chatbot var\n";
} catch (Exception $e) {
    echo "❌ Database hatası: " . $e->getMessage() . "\n";
    exit();
}

// Test 3: Aktif chatbot
echo "\n3. Aktif chatbot testi:\n";
try {
    $stmt = $pdo->query("SELECT id, name FROM chatbots WHERE is_active = 1 LIMIT 1");
    $active = $stmt->fetch();
    if ($active) {
        echo "✅ Aktif chatbot: {$active['name']} (ID: {$active['id']})\n";
    } else {
        echo "⚠️ Aktif chatbot yok\n";
    }
} catch (Exception $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}

// Test 4: Conversation test
echo "\n4. Conversation testi (ID: 5):\n";
try {
    $stmt = $pdo->prepare("
        SELECT c.id, c.chatbot_id, c.is_ai_active, cb.name as chatbot_name
        FROM conversations c
        LEFT JOIN chatbots cb ON c.chatbot_id = cb.id
        WHERE c.id = 5
    ");
    $stmt->execute();
    $conv = $stmt->fetch();
    
    if ($conv) {
        echo "✅ Conversation bulundu\n";
        echo "   - Chatbot: " . ($conv['chatbot_name'] ?? 'Atanmamış') . "\n";
        echo "   - AI Aktif: " . ($conv['is_ai_active'] ? 'Evet' : 'Hayır') . "\n";
    } else {
        echo "❌ Conversation bulunamadı\n";
    }
} catch (Exception $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}

echo "\n✅ Tüm testler tamamlandı!\n";
?>
