Instomer 2026 - Proje İçeriği ve Modüller 
Proje Vizyonu: Müşteri desteği, servis operasyonları, satış ve pazarlama süreçlerini tek bir platformda birleştiren; hesap (account) ve çalışma alanı (workspace) mimarisiyle organize olmuş, yapay zeka destekli asistanlarla güçlendirilmiş, çok kanallı, tam kapsamlı bir müşteri etkileşim platformu oluşturmak.
Görsel Kimlik ve UI/UX Prensipleri
Uygulamanın modern, temiz ve kullanıcı dostu bir arayüze sahip olması hedeflenmektedir. Görsel kimlik, marka kılavuzundan alınan keskinlik ve dinamizm ilkeleriyle uyumludur.
Renk Paleti
Marka kılavuzuna dayalı temel renkler ve kullanım amaçları:
Renk Rolü
Hex Kodu
Kullanım Amacı
Ana Vurgu (Primary/Accent)
#FF2400
Butonlar, Aktif Seçimler, Önemli Bildirimler, Satış Fırsatları (Deal) için kritik sinyaller.
Arka Plan 1 (Beyaz)
#FFFFFF
Aydınlık Mod'da kartlar ve ana çalışma modülleri.
Arka Plan 2 (Açık Gri)
#F5F5F7
Aydınlık Mod'da uygulama genel arka planı ve pasif alanlar.
Ana Metin/Simge
#000000
Başlıklar ve yüksek kontrast gerektiren metinler.
İkincil Metin/Kenarlık
#302E2D
Açıklama metinleri, pasif butonlar ve arayüz bölücü çizgiler.

Tema Seçenekleri
Aydınlık Mod (Varsayılan): Arka Plan #F5F5F7 ve #FFFFFF, Metin #000000.
Karanlık Mod (Alternatif): Arka Plan Antrasit (#121212), Metin #FFFFFF, Vurgu #FF2400.
Tipografi
Ana Başlıklar ve Vurgular: Montserrat (Büyük ve Kalın)
Açıklamalar ve Gövde Metni: Open Sans (Okunabilir büyüklükte)
Tasarım İlkeleri
Keskinlik: Görseller, gölgeler ve geçişler keskin olmalıdır; blur veya opaklık düşürme kullanılmamalıdır.
Hiyerarşi: Kalın (Montserrat) ve ince (Open Sans) yazı tipleri, kritik bilgileri ayırt etmek için birlikte kullanılmalıdır. Önemli kelimeler vurgu rengiyle (#FF2400) patlatılmalıdır.
Modül 0: Temel Platform ve Yönetim (Workspace)
Platformun temel yapı taşlarının, kullanıcılarının ve entegrasyonlarının yönetildiği ana yönetim modülüdür.
0.1. Platform Hiyerarşisi (Account & Workspace)
Birim
Özellikler
Account (Hesap)
En üst seviye organizasyon. Faturalandırma, lisans ve genel Yönetici yetkilendirmesi.
Workspace (Çalışma Alanı)
Hesaba bağlı bağımsız ortam. Her birim kendi kanal, ekip ve biletleme ayarlarına sahiptir (Örn: "Türkiye Satış", "Global Destek").

0.2. Kullanıcı & Takım Yönetimi
Kullanıcı Ekleme/Çıkarma: Çalışma alanına kullanıcı (temsilci) ekleme, rol ve yetki (RBAC) atama.
Takım Tanımlama: Biletlerin otomatik veya manuel olarak atanacağı mantıksal takımlar oluşturma (Örn: "Tier 1 Destek", "Finans").
Rol Bazlı Erişim Kontrolü (RBAC): Kullanıcının hangi verilere ve hangi modüllere erişebileceğini detaylıca belirleme.
0.3. Bilgi Bankası (Self-Servis)
Amaç: Müşterilerin kendi sorunlarını çözebilmesi ve temsilcilerin hızlı yanıt verebilmesi için merkezi bilgi deposu.
Özellikler: Zengin metin editörü ile makaleler, SSS ve rehberler oluşturma. Makaleleri kategorilere ayırma ve yayınlama. Çok Dilli İçerik Yönetimi (Modül 8.2 ile entegre).
AI Kaynak Yönetimi: AI botlarını beslemek için harici ve dahili kaynakları tanımlama.
Web Kazıma: Şirketin halka açık web sayfalarını (blog, fiyatlandırma vb.) düzenli olarak kazımak için URL tanımlama.
Belge Yükleme: Statik PDF, Word veya Excel dosyalarını yükleme (Yıllık raporlar, teknik özellikler).
Dinamik Veri Beslemeleri: Modül 0.5 üzerinden bağlantısı yapılan, sürekli güncellenen online veri akışlarını (borsa, haber, fiyatlandırma, sosyal medya trendleri) AI için sorgulanabilir bir bilgi kaynağı olarak dizinleme.
0.4. Kanal Yapılandırması ve Canlı Destek Widget'ı (Davranışsal Takip Entegrasyonu)
Tanım: Workspace'in kullanacağı tüm harici kanalların (E-posta, WhatsApp, Instagram Ses, Web Widget vb.) bağlantı ayarlarının ve yapılandırmasının yapıldığı alan.
Canlı Destek Widget'ı (SDK): Web sitesine kolayca entegre edilebilmesi için özelleştirilebilir bir kod parçacığı (snippet) oluşturma. Widget'ın rengi, konumu, başlangıç mesajı ve Mobil/Masaüstü görünüm ayarları bu alanda yapılır.
Gelişmiş Takip (Tracking) SDK'sı:
Davranışsal Veri Toplama: Ziyaret edilen sayfaların URL'leri, başlıkları ve ziyaret sürelerinin otomatik olarak toplanması.
Form İzleme: Web sitesindeki form doldurma olaylarının yakalanması.
Anonim Kullanıcı Tanımlama ve Çerez Yönetimi: Kullanıcı anonim olarak izlenir; e-posta girişi yapıldığında, bu geçmiş veriler Modül 2'deki kontakla eşleştirilir. Tarayıcıda kullanıcıyı tanımak için çerez (cookie) kullanılır.
0.5. Harici Entegrasyonlar ve API (Dış Sistem Etkileşimi)
API ve Webhooks: Geliştiriciler için esnek API altyapısı. Olay bazlı tetikleyiciler için Webhook gönderme/alma yeteneği.
Hazır Entegrasyonlar: Slack, Microsoft Teams, CRM (Salesforce, HubSpot) ve E-ticaret platformları (Shopify, WooCommerce) ile önceden yapılandırılmış bağlantılar.
API Aracı (Action Tool): Botların (Modül 3) ve Otomasyon Akışlarının (Modül 5) kullanabileceği, harici sistemlere (ERP, Kargo Takip, E-ticaret) HTTP çağrıları yapma (GET, POST, PUT) yeteneğinin yapılandırıldığı alan.
Dinamik Veri Beslemeleri Yönetimi: Harici sistemlerden (JSON API, RSS/Atom, GraphQL) sürekli güncel veri akışlarının (online feed) bağlantısının kurulduğu ve senkronizasyon sıklığının (cron job) belirlendiği yönetim arayüzü.
Modül 1: Etkileşim Merkezi (Unified Inbox & Ticketing)
Tüm çok kanallı müşteri iletişiminin toplandığı ve yönetildiği platformun ana çalışma alanıdır.
Alan
Özellikler
Kullanıcı Arayüzü
Üç Sütunlu Yerleşim: Görüşme Listesi, Aktif Görüşme, Müşteri Bilgileri Paneli (Modül 2 verilerini gösterir).
Desteklenen Kanallar
Canlı Sohbet (Widget), E-posta, WhatsApp, Telegram, SMS, Facebook/Instagram/Twitter DM ve Yorumlar (Facebook, Instagram, YouTube, LinkedIn).
Biletleme Sistemi
Her etkileşim benzersiz bir "Bilet" (Ticket) olarak oluşturulur. Durum yönetimi (Yeni, Açık, Beklemede, Çözüldü), Önceliklendirme, Özelleştirilebilir Etiketleme.
İşbirliği
Temsilciler arasında özel notlar bırakma, @mention ile diğer kullanıcıları bilgilendirme ve biletleri takımlar/kişiler arasında paslaşma (transfer). Anlık Çeviri Görünümü (Modül 8.2).

Modül 2: Müşteri Kayıtları (Contacts & CRM)
Tüm kişilerin (müşteriler ve potansiyeller) yönetildiği, sınıflandırıldığı ve satış süreçlerinin takip edildiği modüldür.
2.1. Contact Yönetimi
Birleşik Müşteri Profili: Müşterinin tüm geçmiş biletleri, etkileşimleri, notları, atanan fırsatları ve e-ticaret verileri tek bir profilde toplanır.
Davranış Zaman Tüneli: Müşterinin ziyaret ettiği sayfalar, doldurduğu formlar, e-ticaret olayları (Sepete_Eklendi, Satın_Alındı vb.) kronolojik olarak bu profilde görüntülenir.
Kontak Değerlendirme Puanı (Lead Scoring): Kritik etkinliklere (fiyatlandırma sayfasını ziyaret etme vb.) göre otomatik puan ataması.
2.2. Dinamik Segmentler (Akıllı Segmentler)
Tanım: Pazarlama Otomasyonu (Modül 5) ile entegre olarak, kontakları davranışsal, demografik veya etkileşim geçmişine göre otomatik listelere ayırma.
Örnekler: "Yeni Müşteriler", "Pasif Kullanıcılar", "Son 7 günde fiyatlandırma sayfasını 3 kereden fazla ziyaret edenler".
Kullanım: Bu segmentler, Modül 5'teki otomatik kampanyalar için hedef kitle oluşturur.
2.3. Satış Aşamaları (Pipeline)
Fırsat (Deal) Yönetimi: Destek veya iletişim kanallarından gelen potansiyel müşterileri tek tıkla "Fırsat" olarak işaretleme. Fırsatlara parasal değer, kapanış tarihi ve olasılık atama.
Satış Pijaması (Kanban): Özelleştirilebilir aşamalardan oluşan (Örn: Potansiyel Müşteri > Teklif Gönderildi > Anlaşma Kapandı) görsel bir Kanban Panosu ile fırsatların ilerlemesini takip etme.
Modül 3: AI Asistanlar ve Takım Yapısı (Teams & AI)
Yapay zekâ ve insan gücünün koordineli çalıştığı yapılandırma ve iş akışı modülüdür.
3.1. Temsilci & Takım Yönetimi (Kişiler)
Detaylı Rol Ataması: Her temsilcinin (Kişi) hangi WorkSpace, Hangi Takım ve Hangi Kanallardan sorumlu olacağının belirlenmesi.
AI Destekli Yönlendirme: AI Asistanlar (Botlar) tarafından analiz edilen biletlerin, otomatik olarak doğru takıma veya temsilciye atanması.
3.2. İç Ekip İletişimi (Dahili Sohbet)
Amaç: Temsilcilerin platformu terk etmeden, bilet bağlamında veya genel konularda hızlı ve özel iletişim kurması.
Özellikler:
Birebir ve Kanal Sohbetleri: Genel, takım bazlı ve özel kanallar oluşturma. Temsilciler arasında birebir özel mesajlaşma (DM).
Temsilci Tıklama ile Sohbet: Modül 1'deki bilet atamaları veya Modül 0.2'deki kullanıcı listeleri üzerinden herhangi bir temsilciye tıklayarak anında özel sohbet başlatma.
Biletle İlişkilendirme: Modül 1'deki biletlerin sağ sütununda özel bir sekme ile o biletle ilgili tüm dahili konuşmaların saklanması.
Durum Göstergeleri: Temsilcilerin müsaitlik (Online, Meşgul, Görüşme Dışı) durumlarını gösterme.
3.3. Botların Tanımlanması ve Yönetimi (Botlar)
Bot Tanımlama Arayüzü: Yöneticilerin yeni AI ajanları tanımlayabileceği, rollerini, erişebilecekleri araçları (API'ler, Veritabanı) ve temel kişilik (persona) prompt'larını girebileceği merkezi bir panel. (Antigravity ortamının yapılandırma alanı).
Botların Ana Rolleri:
| Bot Tipi | Birincil Görev Alanı | Modül İlişkisi |
| :--- | :--- | :--- |
| AI Servis Danışmanı | Müşteri destek biletlerini analiz etme, etiketleme ve anında bilgi bankası/e-ticaret yanıtları verme. API Aracı (Modül 0.5) kullanarak anlık sipariş/kargo bilgisi çeker. | Modül 1, Modül 0.3, Modül 0.5 |
| AI Satış Danışmanı | Müşteri yazışmalarından satış sinyali tespiti, ürün/hizmet önerme ve temsilciye taslak hazırlama. Kontak Değerlendirme Puanını (Modül 2) kullanır. | Modül 2 |
| Rezervasyon Botu | Müşterinin talebine göre uygun kaynakları (personel, mekan) Modül 4'teki takvim üzerinden kontrol etme ve rezervasyon randevusu oluşturma. | Modül 4 |
| Metin Okuma/Yazma Botu | Santralden gelen sesli aramaları metne çevirme (Speech-to-Text) ve gelecekteki IVR'da metinsel yanıtları sese çevirme (Text-to-Speech). | Modül 6 |
| İç İletişim (IK) Botu | İç ekip kanallarında veya dahili sohbette (Modül 3.2), İK politikaları, izin günleri ve şirket içi SSS'lere anında yanıt verme. | Modül 3.2, Modül 0.5 |
Bot Yetkilendirmesi: Her botun hangi kanallarda aktif olacağının ve hangi takımlarla iş birliği yapacağının belirlenmesi.
AI Kaynak Yapılandırması: Botun hangi Modül 0.3 kaynaklarını (SSS, Bilet Geçmişi, Web Kazıma verisi, Dinamik Veri Beslemeleri) ve hangi Modül 0.5 harici araçlarını (API'ler) kullanacağının belirlenmesi.
Modül 4: Takvim ve Kaynak Yönetimi (Scheduling & Resources)
Zaman yönetimi, ekipman ve personel rezervasyonlarının yapıldığı modüldür.
Kişisel Takvim: Temsilcilerin görevlerini, toplantılarını yönetebileceği ve harici takvimlerle (Google, Outlook) senkronize edilebileceği görünüm.
Kaynak Tanımlama: Yöneticilerin "İnsan", "Ekipman", "Mekan" gibi kaynak türleri ve spesifik kaynaklar (Örn: "Dr. Ayşe Kaya", "Ameliyathane 3") tanımlaması.
Rezervasyon Yönetimi: Kaynakların uygunluk durumunu takvimde görüntüleme ve belirli bir bilet (Modül 1) veya fırsat (Modül 2) ile ilişkilendirerek rezervasyon yapabilme. (Rezervasyon Botu tarafından kullanılır).
Modül 5: Pazarlama ve İş Akışı Otomasyonu
Müşteri etkileşimlerine dayalı otomatik pazarlama ve dahili iş akışlarını yönetme.
5.1. Kampanya Yönetimi
Toplu İletişim: Modül 2'deki Dinamik Segmentlere toplu E-posta ve SMS gönderimi.
Şablon Editörü: Sürükle-bırak arayüzü ile profesyonel görünümlü e-posta şablonları oluşturma.
5.2. Görsel Akış Tasarımcısı
Otomasyon Akışları: "Eğer... ise... yap" mantığıyla çalışan kuralları görsel bir arayüzde tasarlama.
Tetikleyiciler:
Event Bazlı: "Yeni müşteri kaydolduğunda", "Bilet çözüldüğünde", "Müşteri bir ürünü sepete eklediğinde", "Sayfa_Ziyareti_Yapıldığında".
Zaman Bazlı: "Son alışverişten 30 gün sonra".
Aksiyonlar (Actions): Akış içinde gerçekleştirilebilecek eylemler. Modül 0.5'teki API Aracı ile dış sistemlere veri yazma veya çekme aksiyonlarını içerir.
Modül 6: Sesli İletişim ve Santral
Sesli iletişimin yönetimi ve platforma entegrasyonu.
Gelecek Vizyonu: Tam kapsamlı AI Destekli IVR ve WebRTC üzerinden doğrudan arama yapma/alma.
Mevcut Durum (Başlangıç): Santral (PBX) bağlantısı kurulur. Gelen aramalar platforma düşer ve yalnızca sesli konuşma metne çevrilerek (Speech-to-Text) ilgili müşteri biletine (Modül 1) not olarak yazılır. Temsilci, arama geçmişini ve içeriğini metin olarak görebilir. Giden arama işlevi ilk aşamada yoktur. (Metin Okuma/Yazma Botu tarafından yürütülür).
Modül 7: Raporlama ve Analitik
Platform genelindeki performansın ölçümlenmesi.
Destek Metrikleri: İlk yanıt süresi, bilet çözüm süresi, temsilci performansı, kanal bazlı bilet hacmi.
Satış Metrikleri: Satış pijamasındaki dönüşüm oranları, temsilci başına kapatılan fırsat sayısı, ortalama anlaşma büyüklüğü.
Gelişmiş Raporlama: Kullanıcıların kendi gösterge panellerini (Dashboard) oluşturabileceği ve verileri görselleştirebileceği BI katmanı.
Modül 8: Kurumsal Yetenekler ve Genişletmeler (Yeniden Düzenlendi)
Bu modül, artık sadece kullanıcı deneyimini ve platformun erişilebilirliğini artırmaya odaklanmaktadır.
8.1. Kalite Güvencesi ve Geri Bildirim
Görüşme Denetimi (QA): Yöneticilerin rastgele veya filtreli biletleri açıp önceden tanımlanmış kriterlere (Dilbilgisi, Çözüm Kalitesi, Ton) göre puan verebileceği bir arayüz. Bu puanlar Modül 7'ye yansıtılır.
Otomatik Memnuniyet Anketleri (CSAT/NPS): Modül 5'teki Otomasyon Akışları ile tetiklenen, müşterilere gönderilen otomatik anketler. Sonuçlar Modül 7'de raporlanır.
AI Kalite Analizi: (Modül 3.3'teki AI Servis Botu) Bilet kapandıktan sonra, tüm görüşme geçmişini analiz ederek temsilcinin tonunu ve çözüm kalitesini otomatik olarak (ön)değerlendirir.
8.2. Çoklu Dil Desteği ve Yerelleştirme
Arayüz Yerelleştirmesi: Platform arayüzünün (menüler, butonlar) kullanıcının tercih ettiği dilde (TR, EN, DE, vb.) görüntülenmesi.
Anlık Görüşme Çevirisi: Modül 1'deki aktif görüşmelerde müşteri ve temsilci mesajlarının anlık olarak birbirlerinin diline çevrilmesi (Google Translate API/AI Servisleri üzerinden).
Çok Dilli Bilgi Bankası: Modül 0.3'teki makalelerin birden fazla dilde yönetilebilmesi.
8.3. Kullanıcı Deneyimi Genişletmeleri
Mobil Uygulamalar: Temsilciler için Native iOS & Android uygulamaları.
Müşteri Portalı: Müşterilerin geçmiş biletlerini ve profillerini yönetebildiği güvenli portal.
Modül 9: Kurumsal Yönetim ve Operasyonel Kontrol (Owner/Admin View)
Platform sahibinin ve üst düzey yöneticilerin (Üst Katman) ihtiyaç duyduğu kritik yönetim, güvenlik ve operasyonel takip araçlarını içerir.
9.1. Faturalandırma, Lisans ve Kullanım Yönetimi
Abonelik ve Paket Yönetimi: Hesabın aktif abonelik planını, kullanıcı (koltuk) limitlerini ve lisans yükseltmelerini yönetme.
Gelişmiş Kullanım ve Maliyet Analizi:
Özellik Kullanımı: Hangi Modülün/Özelliğin (Örn: AI Botlar, Otomasyon Akışları, Çoklu Kanal) ne sıklıkla kullanıldığına dair detaylı döküm.
Maliyet Metrikleri: Temsilci başına ortalama bilet maliyeti, AI servisleri için harcama dökümü (Modül 7'ye ek olarak finansal odaklı raporlama).
Ödeme Geçmişi: Faturaları görüntüleme, indirme ve ödeme yöntemlerini güncelleme.
9.2. Güvenlik ve Denetim (Logs)
Denetim Kayıtları (Audit Logs) Merkezi: (Loglar)
Amaç: Yönetici eylemlerinde şeffaflık ve güvenlik sağlamak.
Özellikler: Platformdaki tüm kritik eylemlerin (Kullanıcı ekleme/silme, Workspace ayarı değiştirme, yetki atama, bilet silme) kimin tarafından, ne zaman yapıldığını gösteren detaylı, filtrelenebilir ve arşivlenebilir kayıtlar.
Güvenlik ve Uyumluluk: İki Faktörlü Kimlik Doğrulama (2FA), KVKK/GDPR uyumluluk araçları ve veri saklama politikalarının yönetimi.
Rol Bazlı Erişim Kontrolü (RBAC): (Modül 0.2'den beslenir) Tüm modüller ve verilere erişim yetkilerini merkezi bir panelden yönetme.
9.3. Sistem Sağlığı ve Destek (Destek)
Durum Paneli (Status Dashboard): (Sistem Desteği) Instomer platformunun teknik bileşenlerinin (Veritabanı, AI Servisleri, WebSockets sunucuları, Harici API Bağlantıları) gerçek zamanlı çalışma durumunu ve hizmet kesintilerini gösteren halka açık veya dahili dashboard.
Hata ve İstisna İzleme: Otomatik olarak toplanan uygulama hataları ve uyarılarının merkezi görünümü (SRE/Operasyon ekipleri için).
Dahili Platform Destek Sistemi: Instomer'ı kullanan müşterilere veya Instomer'ın kendi operasyon ekibine yönelik teknik destek bileti oluşturma, takip etme ve çözme mekanizması (Platformun kendi desteği).




