<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facebook App Review Rehberi</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1877f2 0%, #0a4fb5 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            color: #1877f2;
            text-align: center;
            margin-bottom: 10px;
            font-size: 36px;
        }
        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 40px;
            font-size: 18px;
        }
        .section {
            margin: 30px 0;
            padding: 25px;
            background: #f8f9fa;
            border-radius: 12px;
            border-left: 5px solid #1877f2;
        }
        .section h2 {
            color: #1877f2;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .step {
            background: white;
            padding: 20px;
            margin: 15px 0;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .step-number {
            display: inline-block;
            background: linear-gradient(135deg, #1877f2 0%, #0a4fb5 100%);
            color: white;
            width: 35px;
            height: 35px;
            border-radius: 50%;
            text-align: center;
            line-height: 35px;
            font-weight: bold;
            margin-right: 15px;
        }
        .step-title {
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
            font-size: 18px;
        }
        .step-content {
            color: #666;
            line-height: 1.6;
            margin-left: 50px;
        }
        .code-box {
            background: #2d2d2d;
            color: #f8f8f2;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
        }
        .warning {
            background: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .warning strong {
            color: #856404;
        }
        .success {
            background: #d4edda;
            border-left: 5px solid #28a745;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .success strong {
            color: #155724;
        }
        .info {
            background: #d1ecf1;
            border-left: 5px solid #17a2b8;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .checklist {
            list-style: none;
            padding: 0;
        }
        .checklist li {
            padding: 12px;
            margin: 8px 0;
            background: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
        }
        .checklist li::before {
            content: "☐";
            font-size: 24px;
            margin-right: 15px;
            color: #1877f2;
        }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: linear-gradient(135deg, #1877f2 0%, #0a4fb5 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: bold;
            margin: 10px 10px 10px 0;
            transition: all 0.3s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(24, 119, 242, 0.4);
        }
        .btn-secondary {
            background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
        }
        .timeline {
            position: relative;
            padding-left: 40px;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 15px;
            top: 0;
            bottom: 0;
            width: 3px;
            background: #1877f2;
        }
        .timeline-item {
            position: relative;
            padding: 20px;
            background: white;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -33px;
            top: 25px;
            width: 15px;
            height: 15px;
            border-radius: 50%;
            background: #1877f2;
            border: 3px solid white;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📘 Facebook App Review Rehberi</h1>
        <p class="subtitle">pages_messaging İzni İçin Adım Adım Başvuru</p>

        <div class="info">
            <strong>🎯 Hedef:</strong> Facebook'tan otomatik kullanıcı ismi çekmek için <code>pages_messaging</code> iznini almak.
        </div>

        <div class="section">
            <h2>📋 Ön Hazırlık (Yapılması Gerekenler)</h2>
            
            <ul class="checklist">
                <li>Facebook Business hesabın olmalı</li>
                <li>Facebook Page'in olmalı (aktif ve yayında)</li>
                <li>Facebook App'in oluşturulmuş olmalı</li>
                <li>CRM sistemi çalışır durumda olmalı</li>
                <li>Webhook URL'i erişilebilir olmalı</li>
                <li>Privacy Policy (Gizlilik Politikası) sayfası olmalı</li>
                <li>Terms of Service (Kullanım Koşulları) sayfası olmalı</li>
            </ul>
        </div>

        <div class="section">
            <h2>🚀 Adım Adım App Review Başvurusu</h2>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">1</span>
                    Facebook Developers Console'a Git
                </div>
                <div class="step-content">
                    <a href="https://developers.facebook.com/apps/" target="_blank" class="btn">
                        🔗 Facebook Developers Console
                    </a>
                    <p style="margin-top: 10px;">App'ini seç ve Dashboard'a git.</p>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">2</span>
                    App Review Sayfasına Git
                </div>
                <div class="step-content">
                    <p>Sol menüden: <strong>App Review → Permissions and Features</strong></p>
                    <p style="margin-top: 10px;">Burada <code>pages_messaging</code> iznini bulacaksın.</p>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">3</span>
                    pages_messaging İznini Bul ve "Request" Tıkla
                </div>
                <div class="step-content">
                    <p><code>pages_messaging</code> iznini ara ve <strong>"Request Advanced Access"</strong> butonuna tıkla.</p>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">4</span>
                    Başvuru Formunu Doldur
                </div>
                <div class="step-content">
                    <p><strong>App Name:</strong> MultiCRM</p>
                    <p><strong>App Description:</strong></p>
                    <div class="code-box">
MultiCRM is a customer relationship management system that helps businesses 
manage customer conversations from Facebook Messenger. We need pages_messaging 
permission to:

1. Receive messages from customers
2. Send responses to customers
3. Retrieve customer profile information (name) for better service
4. Manage customer conversations efficiently

Our system helps businesses provide better customer support by organizing 
all customer messages in one place.
                    </div>
                    
                    <p style="margin-top: 20px;"><strong>How will you use this permission:</strong></p>
                    <div class="code-box">
We use pages_messaging to:
- Receive incoming messages from Facebook Messenger users
- Retrieve user profile information (first_name, last_name) to personalize conversations
- Send automated and manual responses to customer inquiries
- Manage customer support conversations through our CRM interface
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">5</span>
                    Ekran Görüntüleri ve Video Hazırla
                </div>
                <div class="step-content">
                    <p><strong>Facebook şunları isteyecek:</strong></p>
                    <ul style="margin-left: 20px; margin-top: 10px;">
                        <li>CRM arayüzünün ekran görüntüleri</li>
                        <li>Mesajlaşma özelliğinin nasıl çalıştığını gösteren video (1-2 dakika)</li>
                        <li>Kullanıcı profil bilgilerinin nasıl kullanıldığını gösteren ekran görüntüsü</li>
                    </ul>
                    
                    <div class="warning" style="margin-top: 20px;">
                        <strong>⚠️ Önemli:</strong> Video'da şunları göster:
                        <ul style="margin-left: 20px; margin-top: 10px;">
                            <li>Facebook Messenger'dan mesaj gelişi</li>
                            <li>CRM'de mesajın görünmesi</li>
                            <li>Kullanıcı isminin CRM'de görünmesi</li>
                            <li>CRM'den cevap gönderme</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">6</span>
                    Privacy Policy ve Terms of Service Ekle
                </div>
                <div class="step-content">
                    <p>Facebook, Privacy Policy ve Terms of Service URL'leri isteyecek.</p>
                    <p style="margin-top: 10px;"><strong>Örnek Privacy Policy:</strong></p>
                    <a href="create-privacy-policy.php" class="btn btn-secondary">
                        📄 Privacy Policy Oluştur
                    </a>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">7</span>
                    Test Hesabı ve Bilgiler Sağla
                </div>
                <div class="step-content">
                    <p>Facebook, uygulamanı test etmek için şunları isteyecek:</p>
                    <ul style="margin-left: 20px; margin-top: 10px;">
                        <li><strong>Test User:</strong> Facebook test hesabı</li>
                        <li><strong>Test Page:</strong> Facebook sayfan</li>
                        <li><strong>Login Credentials:</strong> CRM giriş bilgileri</li>
                    </ul>
                    
                    <div class="code-box" style="margin-top: 15px;">
<strong>CRM Login Bilgileri (Facebook'a verilecek):</strong>
URL: https://profaj.co/multicrm/
Username: [Test kullanıcı adı]
Password: [Test şifresi]

<strong>Facebook Page:</strong>
[Senin Facebook sayfan URL'i]

<strong>Test Instructions:</strong>
1. Go to Facebook Page and send a message
2. Login to CRM with provided credentials
3. See the message appear in CRM with user's name
4. Reply to the message from CRM
5. Check Facebook Messenger for the reply
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-title">
                    <span class="step-number">8</span>
                    Başvuruyu Gönder
                </div>
                <div class="step-content">
                    <p>Tüm bilgileri doldurduktan sonra <strong>"Submit for Review"</strong> butonuna tıkla.</p>
                    <div class="success" style="margin-top: 15px;">
                        <strong>✅ Başvuru Gönderildi!</strong> Facebook genellikle 3-7 iş günü içinde cevap verir.
                    </div>
                </div>
            </div>
        </div>

        <div class="section">
            <h2>⏱️ Beklenen Süreç</h2>
            
            <div class="timeline">
                <div class="timeline-item">
                    <strong>Gün 0:</strong> Başvuru gönderildi
                </div>
                <div class="timeline-item">
                    <strong>Gün 1-2:</strong> Facebook otomatik kontroller yapıyor
                </div>
                <div class="timeline-item">
                    <strong>Gün 3-5:</strong> Manuel inceleme başlıyor
                </div>
                <div class="timeline-item">
                    <strong>Gün 5-7:</strong> Sonuç bildirimi (onay veya red)
                </div>
            </div>
        </div>

        <div class="warning">
            <strong>⚠️ Red Edilirse Ne Olur?</strong>
            <p style="margin-top: 10px;">Eğer başvurun reddedilirse:</p>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>Facebook red nedenini açıklayacak</li>
                <li>Eksiklikleri tamamlayıp tekrar başvurabilirsin</li>
                <li>Genellikle 2-3 deneme sonrası onaylanır</li>
            </ul>
        </div>

        <div class="success">
            <strong>✅ Onaylanırsa Ne Olur?</strong>
            <p style="margin-top: 10px;">Onaylandıktan sonra:</p>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>CRM otomatik olarak Facebook'tan kullanıcı isimlerini çekecek</li>
                <li>Yeni müşteriler gerçek isimleriyle görünecek</li>
                <li>Manuel isim girmeye gerek kalmayacak</li>
            </ul>
        </div>

        <div style="text-align: center; margin-top: 40px;">
            <a href="https://developers.facebook.com/apps/" target="_blank" class="btn">
                🚀 Şimdi Başvur
            </a>
            <a href="index.php" class="btn btn-secondary">
                🏠 Ana Sayfa
            </a>
        </div>

        <div class="info" style="margin-top: 30px;">
            <strong>💡 İpucu:</strong> Başvuru sırasında webhook'u çalışır durumda tut. Facebook test edecek!
        </div>
    </div>
</body>
</html>

