<?php
/**
 * Facebook Kurulum Sihirbazı
 * Veritabanını otomatik günceller ve Facebook ayarlarını yapılandırır
 */

session_start();
require_once 'config/database.php';

// Basit güvenlik kontrolü
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$step = $_GET['step'] ?? 1;
$message = '';
$error = '';

// Adım 1: Veritabanı Kontrolü
if ($step == 1 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Settings tablosunu kontrol et
        $stmt = $pdo->query("SHOW TABLES LIKE 'settings'");
        $settingsExists = $stmt->rowCount() > 0;
        
        if (!$settingsExists) {
            throw new Exception("Settings tablosu bulunamadı! Önce ana kurulumu tamamlayın.");
        }
        
        // Facebook ayarlarını kontrol et
        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM settings WHERE `key` LIKE 'facebook_%'");
        $stmt->execute();
        $result = $stmt->fetch();
        
        if ($result['count'] > 0) {
            $message = "✅ Facebook ayarları zaten mevcut. Güncelleme yapılacak.";
        } else {
            $message = "⚠️ Facebook ayarları bulunamadı. Yeni kayıtlar eklenecek.";
        }
        
        $step = 2;
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}

// Adım 2: Facebook Ayarlarını Ekle/Güncelle
if ($step == 2 && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['install'])) {
    try {
        $settings = [
            ['key' => 'facebook_page_id', 'value' => '', 'type' => 'string', 'description' => 'Facebook Sayfa ID'],
            ['key' => 'facebook_page_access_token', 'value' => '', 'type' => 'string', 'description' => 'Facebook Sayfa Erişim Token'],
            ['key' => 'facebook_app_id', 'value' => '9552148291508378', 'type' => 'string', 'description' => 'Facebook App ID'],
            ['key' => 'facebook_app_secret', 'value' => '88968d9ae1e845d732f9f3c3424b9d20', 'type' => 'string', 'description' => 'Facebook App Secret'],
            ['key' => 'facebook_verify_token', 'value' => 'profaj_whatsapp_2024', 'type' => 'string', 'description' => 'Facebook Webhook Doğrulama Token'],
            ['key' => 'facebook_webhook_url', 'value' => 'https://profaj.co/multicrm/api/webhook-facebook.php', 'type' => 'string', 'description' => 'Facebook Webhook URL'],
            ['key' => 'facebook_api_version', 'value' => 'v18.0', 'type' => 'string', 'description' => 'Facebook API Versiyonu']
        ];

        $added = 0;
        $updated = 0;
        
        foreach ($settings as $setting) {
            $stmt = $pdo->prepare("SELECT id FROM settings WHERE `key` = ?");
            $stmt->execute([$setting['key']]);
            $exists = $stmt->fetch();

            if ($exists) {
                // Güncelle (sadece boş olanları)
                $stmt = $pdo->prepare("UPDATE settings SET `type` = ?, `description` = ?, updated_at = NOW() WHERE `key` = ? AND (`value` = '' OR `value` IS NULL)");
                $stmt->execute([$setting['type'], $setting['description'], $setting['key']]);
                $updated++;
            } else {
                // Ekle
                $stmt = $pdo->prepare("INSERT INTO settings (`key`, `value`, `type`, `description`, created_at, updated_at) VALUES (?, ?, ?, ?, NOW(), NOW())");
                $stmt->execute([$setting['key'], $setting['value'], $setting['type'], $setting['description']]);
                $added++;
            }
        }

        $message = "✅ Başarılı! $added yeni ayar eklendi, $updated ayar güncellendi.";
        $step = 3;
    } catch (Exception $e) {
        $error = "Hata: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facebook Kurulum Sihirbazı</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #f5f7fa; padding: 40px 0; }
        .wizard-container { max-width: 800px; margin: 0 auto; }
        .step-indicator { display: flex; justify-content: space-between; margin-bottom: 40px; }
        .step { flex: 1; text-align: center; padding: 20px; background: white; margin: 0 5px; border-radius: 8px; position: relative; }
        .step.active { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
        .step.completed { background: #10b981; color: white; }
        .step-number { width: 40px; height: 40px; border-radius: 50%; background: rgba(255,255,255,0.2); display: inline-flex; align-items: center; justify-content: center; font-weight: bold; margin-bottom: 10px; }
        .card { border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        .btn-gradient { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; }
        .btn-gradient:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4); }
        .code-box { background: #1e293b; color: #e2e8f0; padding: 20px; border-radius: 8px; font-family: monospace; margin: 20px 0; }
        .success-icon { font-size: 64px; color: #10b981; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="wizard-container">
        <h1 class="text-center mb-4"><i class="fab fa-facebook"></i> Facebook Kurulum Sihirbazı</h1>
        
        <!-- Step Indicator -->
        <div class="step-indicator">
            <div class="step <?php echo $step >= 1 ? 'active' : ''; ?> <?php echo $step > 1 ? 'completed' : ''; ?>">
                <div class="step-number">1</div>
                <div>Kontrol</div>
            </div>
            <div class="step <?php echo $step >= 2 ? 'active' : ''; ?> <?php echo $step > 2 ? 'completed' : ''; ?>">
                <div class="step-number">2</div>
                <div>Kurulum</div>
            </div>
            <div class="step <?php echo $step >= 3 ? 'active' : ''; ?>">
                <div class="step-number">3</div>
                <div>Tamamlandı</div>
            </div>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>

        <?php if ($message): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <!-- Step 1: Kontrol -->
        <?php if ($step == 1): ?>
            <div class="card">
                <div class="card-body text-center p-5">
                    <i class="fas fa-database" style="font-size: 64px; color: #667eea; margin-bottom: 20px;"></i>
                    <h3>Veritabanı Kontrolü</h3>
                    <p class="text-muted">Facebook ayarları için veritabanınız kontrol edilecek.</p>
                    <form method="POST">
                        <button type="submit" class="btn btn-gradient btn-lg mt-3">
                            <i class="fas fa-check"></i> Kontrolü Başlat
                        </button>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <!-- Step 2: Kurulum -->
        <?php if ($step == 2): ?>
            <div class="card">
                <div class="card-body p-5">
                    <h3><i class="fas fa-cog"></i> Facebook Ayarları Kurulumu</h3>
                    <p class="text-muted">Aşağıdaki ayarlar veritabanınıza eklenecek:</p>
                    
                    <ul class="list-group mb-4">
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_page_id</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_page_access_token</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_app_id</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_app_secret</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_verify_token</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_webhook_url</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> facebook_api_version</li>
                    </ul>

                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> 
                        <strong>Not:</strong> Mevcut ayarlar korunacak, sadece eksik olanlar eklenecek.
                    </div>

                    <form method="POST">
                        <input type="hidden" name="install" value="1">
                        <button type="submit" class="btn btn-gradient btn-lg w-100">
                            <i class="fas fa-download"></i> Ayarları Kur
                        </button>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <!-- Step 3: Tamamlandı -->
        <?php if ($step == 3): ?>
            <div class="card">
                <div class="card-body text-center p-5">
                    <i class="fas fa-check-circle success-icon"></i>
                    <h3>Kurulum Tamamlandı!</h3>
                    <p class="text-muted">Facebook entegrasyonu için veritabanı hazır.</p>

                    <div class="alert alert-info text-start mt-4">
                        <h5><i class="fas fa-list"></i> Sonraki Adımlar:</h5>
                        <ol>
                            <li><a href="settings.php">Ayarlar sayfasına</a> gidin</li>
                            <li>Facebook bölümünde <strong>Page ID</strong> ve <strong>Page Access Token</strong> bilgilerini doldurun</li>
                            <li>Facebook Developer Console'da webhook'u ayarlayın:
                                <div class="code-box mt-2">
URL: https://profaj.co/multicrm/api/webhook-facebook.php<br>
Verify Token: profaj_whatsapp_2024<br>
Subscribe: messages, messaging_postbacks
                                </div>
                            </li>
                            <li><a href="test-facebook-message.php">Test sayfası</a> ile kontrol edin</li>
                        </ol>
                    </div>

                    <div class="d-grid gap-2 mt-4">
                        <a href="settings.php" class="btn btn-gradient btn-lg">
                            <i class="fas fa-cog"></i> Ayarlara Git
                        </a>
                        <a href="index.php" class="btn btn-outline-secondary">
                            <i class="fas fa-home"></i> Ana Sayfaya Dön
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="text-center mt-4">
            <a href="FACEBOOK_SETUP.md" target="_blank" class="text-muted">
                <i class="fas fa-book"></i> Detaylı Kurulum Rehberi
            </a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

