<?php
require_once 'config/database.php';

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔧 FACEBOOK MÜŞTERİ DÜZELTMESİ\n";
echo "═══════════════════════════════════════════════════════════\n\n";

try {
    // Mevcut Facebook müşterilerini bul
    $stmt = $pdo->query("SELECT * FROM customers WHERE facebook_id IS NOT NULL AND facebook_id != ''");
    $customers = $stmt->fetchAll();
    
    echo "Bulunan Facebook müşterileri: " . count($customers) . "\n\n";
    
    foreach ($customers as $customer) {
        echo "─────────────────────────────────────────────────────────\n";
        echo "ID: " . $customer['id'] . "\n";
        echo "İsim: " . $customer['name'] . "\n";
        echo "Facebook ID: " . $customer['facebook_id'] . "\n";
        echo "Telefon: " . ($customer['phone'] ?? 'Yok') . "\n";
        
        // Bu müşterinin sohbetlerini bul
        $stmt2 = $pdo->prepare("SELECT COUNT(*) as count FROM conversations WHERE customer_id = ?");
        $stmt2->execute([$customer['id']]);
        $convCount = $stmt2->fetch()['count'];
        echo "Sohbet sayısı: " . $convCount . "\n";
        
        // Bu müşterinin mesajlarını bul
        $stmt3 = $pdo->prepare("
            SELECT COUNT(*) as count FROM messages m
            JOIN conversations c ON m.conversation_id = c.id
            WHERE c.customer_id = ?
        ");
        $stmt3->execute([$customer['id']]);
        $msgCount = $stmt3->fetch()['count'];
        echo "Mesaj sayısı: " . $msgCount . "\n";
    }
    
    echo "\n═══════════════════════════════════════════════════════════\n";
    echo "✅ Müşteriler listelendi\n";
    echo "\nYeni mesaj gönderdiğinizde isim otomatik güncellenecek!\n";
    echo "═══════════════════════════════════════════════════════════\n";
    
} catch (PDOException $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}
?>

