<?php
/**
 * Sidebar Component
 * Tüm sayfalarda kullanılacak tek sidebar
 */

// Load workspace functions if not already loaded
if (!function_exists('getCurrentWorkspace')) {
    require_once __DIR__ . '/workspace.php';
}

// Aktif sayfa kontrolü
$current_page = basename($_SERVER['PHP_SELF']);
$active_inbox = ($current_page == 'index.php') ? 'active' : '';
$active_contacts = ($current_page == 'customers.php') ? 'active' : '';
$active_settings = ($current_page == 'settings.php') ? 'active' : '';
?>

<!-- Sidebar -->
<div class="col-md-3 sidebar">
    <!-- App Header -->
    <div class="app-header">
        <div class="app-logo">
            <div class="logo-icon">o</div>
            <span class="app-name">profaj</span>
        </div>
    </div>
    
    <!-- Workspace Selector -->
    <?php 
    $currentWorkspace = getCurrentWorkspace();
    $userWorkspaces = getUserWorkspaces($user['id']);
    ?>
    <?php if (count($userWorkspaces) > 0): ?>
    <div class="workspace-selector">
        <div class="current-workspace">
            <div class="workspace-icon">
                <i class="fas fa-building"></i>
            </div>
            <div class="workspace-info">
                <div class="workspace-name"><?php echo htmlspecialchars($currentWorkspace['name'] ?? 'Workspace'); ?></div>
                <small class="workspace-role"><?php echo ucfirst($currentWorkspace['user_role'] ?? 'member'); ?></small>
            </div>
            <div class="workspace-dropdown-icon">
                <i class="fas fa-chevron-down"></i>
            </div>
        </div>
        
        <?php if (count($userWorkspaces) > 1): ?>
        <div class="workspace-dropdown" style="display: none;">
            <?php foreach ($userWorkspaces as $workspace): ?>
                <?php if ($workspace['id'] != $_SESSION['workspace_id']): ?>
                <div class="workspace-item" data-workspace-id="<?php echo $workspace['id']; ?>">
                    <div class="workspace-item-icon">
                        <i class="fas fa-building"></i>
                    </div>
                    <div class="workspace-item-info">
                        <div class="workspace-item-name"><?php echo htmlspecialchars($workspace['name']); ?></div>
                        <small class="workspace-item-role"><?php echo ucfirst($workspace['role']); ?></small>
                    </div>
                    <?php if ($workspace['is_default']): ?>
                    <div class="workspace-default-badge">
                        <i class="fas fa-star"></i>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    
    
    <!-- Navigation Menu -->
    <div class="sidebar-menu">
        <a href="index.php" class="menu-item <?php echo $active_inbox; ?>">
            <i class="far fa-comments"></i> Sohbetler
        </a>
        <a href="customers.php" class="menu-item <?php echo $active_contacts; ?>">
            <i class="fas fa-users"></i> Müşteriler
        </a>
        <?php if ($user['role'] === 'admin'): ?>
        <a href="inboxes.php" class="menu-item <?php echo ($current_page == 'inboxes.php') ? 'active' : ''; ?>">
            <i class="fas fa-inbox"></i> Kanallar
        </a>
        <a href="users.php" class="menu-item <?php echo ($current_page == 'users.php') ? 'active' : ''; ?>">
            <i class="fas fa-user-shield"></i> Kullanıcılar
        </a>
        <a href="workspaces.php" class="menu-item <?php echo ($current_page == 'workspaces.php') ? 'active' : ''; ?>">
            <i class="fas fa-building"></i> Workspace Yönetimi
        </a>
        <?php endif; ?>
        <?php if (in_array($user['role'], ['admin', 'supervisor'])): ?>
        <a href="chatbot-ai.php" class="menu-item <?php echo ($current_page == 'chatbot-ai.php') ? 'active' : ''; ?>">
            <i class="fas fa-robot"></i> Chatbot AI
        </a>
        <a href="customer-info.php" class="menu-item <?php echo ($current_page == 'customer-info.php') ? 'active' : ''; ?>">
            <i class="fas fa-chart-bar"></i> Müşteri Bilgileri
        </a>
        <?php endif; ?>
        <a href="settings.php" class="menu-item <?php echo $active_settings; ?>">
            <i class="fas fa-cogs"></i> Ayarlar
        </a>
    </div>
    
    <!-- User Profile -->
    <div class="user-profile">
        <div class="user-avatar">
            <div class="avatar-circle">
                <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
            </div>
            <div class="online-status"></div>
        </div>
        <div class="user-info">
            <div class="user-name"><?php echo htmlspecialchars($user['name']); ?></div>
            <div class="user-email"><?php echo htmlspecialchars($user['email']); ?></div>
        </div>
    </div>
</div>

<!-- Workspace Switcher Script -->
<script src="assets/js/workspace.js"></script>

