<?php
/**
 * Müşteri Durumu (Customer Status) Sütunu Ekleme
 */

require_once '../config/database.php';

echo "<h2>Müşteri Durumu - Veritabanı Güncellemesi</h2>";

try {
    // conversations tablosuna customer_status sütunu ekle
    echo "<h3>conversations tablosuna customer_status ekleniyor...</h3>";
    
    $stmt = $pdo->query("SHOW COLUMNS FROM conversations LIKE 'customer_status'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("
            ALTER TABLE conversations 
            ADD COLUMN customer_status ENUM('potential', 'info_received', 'negative', 'positive', 'pending') 
            DEFAULT NULL
            AFTER chatbot_id
        ");
        echo "<p style='color: green;'>✅ customer_status sütunu eklendi</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ customer_status sütunu zaten mevcut</p>";
    }
    
    echo "<hr>";
    echo "<h2 style='color: green;'>✅ Güncelleme Tamamlandı!</h2>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
}
?>
