<?php
/**
 * Tüm Conversation'lara Aktif Chatbot'u Ata
 */

require_once '../config/database.php';

echo "<h2>Aktif Chatbot Toplu Atama</h2>";

try {
    // Aktif chatbot'u bul
    $stmt = $pdo->query("SELECT id, name FROM chatbots WHERE is_active = 1 LIMIT 1");
    $active_chatbot = $stmt->fetch();
    
    if (!$active_chatbot) {
        echo "<p style='color: red;'>❌ Aktif chatbot bulunamadı! Önce bir chatbot aktif yapın.</p>";
        exit();
    }
    
    echo "<p style='color: green;'>✅ Aktif Chatbot: <strong>{$active_chatbot['name']}</strong> (ID: {$active_chatbot['id']})</p>";
    
    // Tüm conversation'lara aktif chatbot'u ata
    $stmt = $pdo->prepare("UPDATE conversations SET chatbot_id = ? WHERE chatbot_id IS NULL OR chatbot_id != ?");
    $stmt->execute([$active_chatbot['id'], $active_chatbot['id']]);
    $updated = $stmt->rowCount();
    
    echo "<p style='color: green;'>✅ {$updated} sohbete aktif chatbot atandı!</p>";
    
    // Zamanlama kapalıysa tüm AI'ları aktif yap
    $stmt = $pdo->prepare("SELECT schedule_enabled FROM chatbots WHERE id = ?");
    $stmt->execute([$active_chatbot['id']]);
    $chatbot = $stmt->fetch();
    
    if (!$chatbot['schedule_enabled']) {
        $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 1 WHERE chatbot_id = ?");
        $stmt->execute([$active_chatbot['id']]);
        echo "<p style='color: green;'>✅ Zamanlama kapalı - Tüm sohbetlerde AI aktif edildi!</p>";
    } else {
        echo "<p style='color: blue;'>⏰ Zamanlama aktif - Her sohbet için zamanlama kontrolü yapılacak</p>";
    }
    
    // Güncel durumu göster
    $stmt = $pdo->query("
        SELECT c.id, cust.name as customer, cb.name as chatbot, c.is_ai_active
        FROM conversations c
        LEFT JOIN customers cust ON c.customer_id = cust.id
        LEFT JOIN chatbots cb ON c.chatbot_id = cb.id
        ORDER BY c.id DESC
        LIMIT 10
    ");
    $conversations = $stmt->fetchAll();
    
    echo "<h3>Son 10 Sohbet:</h3>";
    echo "<table border='1' cellpadding='10'>";
    echo "<tr><th>ID</th><th>Müşteri</th><th>Chatbot</th><th>AI</th></tr>";
    foreach ($conversations as $conv) {
        $ai = $conv['is_ai_active'] ? '✅ Aktif' : '❌ Pasif';
        echo "<tr>";
        echo "<td>{$conv['id']}</td>";
        echo "<td>{$conv['customer']}</td>";
        echo "<td>{$conv['chatbot']}</td>";
        echo "<td>{$ai}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<hr>";
    echo "<p><strong>✅ Artık tüm sohbetlerde AI toggle aktif olmalı!</strong></p>";
    echo "<p>Sohbet sayfasını yenileyin ve test edin.</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
}
?>
