<?php
/**
 * Check if workspace_id columns exist
 */
require_once '../config/database.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Database Status Check</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #1e1e1e; color: #fff; }
        .success { color: #4caf50; }
        .error { color: #f44336; }
        .warning { color: #ff9800; }
        table { border-collapse: collapse; width: 100%; margin: 20px 0; }
        th, td { border: 1px solid #444; padding: 10px; text-align: left; }
        th { background: #333; }
    </style>
</head>
<body>
    <h1>📊 Database Schema Check</h1>
    
    <?php
    // Check conversations table
    echo "<h2>Conversations Table</h2>";
    try {
        $stmt = $pdo->query("SHOW COLUMNS FROM conversations");
        echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($row = $stmt->fetch()) {
            $highlight = (strpos($row['Field'], 'workspace') !== false || strpos($row['Field'], 'inbox') !== false) ? 'class="success"' : '';
            echo "<tr $highlight>";
            echo "<td><strong>{$row['Field']}</strong></td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    } catch (Exception $e) {
        echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
    }
    
    // Check customers table
    echo "<h2>Customers Table</h2>";
    try {
        $stmt = $pdo->query("SHOW COLUMNS FROM customers");
        echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($row = $stmt->fetch()) {
            $highlight = (strpos($row['Field'], 'workspace') !== false) ? 'class="success"' : '';
            echo "<tr $highlight>";
            echo "<td><strong>{$row['Field']}</strong></td>";
            echo "<td>{$row['Type']}</td>";
            echo "<td>{$row['Null']}</td>";
            echo "<td>{$row['Key']}</td>";
            echo "<td>{$row['Default']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    } catch (Exception $e) {
        echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
    }
    
    // Check if inboxes table exists
    echo "<h2>Inboxes Table</h2>";
    try {
        $stmt = $pdo->query("SHOW TABLES LIKE 'inboxes'");
        if ($stmt->rowCount() > 0) {
            echo "<p class='success'>✅ Inboxes table exists</p>";
            $stmt = $pdo->query("SHOW COLUMNS FROM inboxes");
            echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
            while ($row = $stmt->fetch()) {
                echo "<tr>";
                echo "<td><strong>{$row['Field']}</strong></td>";
                echo "<td>{$row['Type']}</td>";
                echo "<td>{$row['Null']}</td>";
                echo "<td>{$row['Key']}</td>";
                echo "<td>{$row['Default']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p class='error'>❌ Inboxes table does NOT exist</p>";
            echo "<p class='warning'>⚠️ Please run: <a href='setup-multi-tenant.php' style='color: #4caf50;'>setup-multi-tenant.php</a></p>";
        }
    } catch (Exception $e) {
        echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
    }
    
    // Check data counts
    echo "<h2>Data Summary</h2>";
    echo "<table>";
    
    $tables = ['agencies', 'conversations', 'customers', 'messages', 'users'];
    foreach ($tables as $table) {
        try {
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM $table");
            $count = $stmt->fetch()['count'];
            echo "<tr><td><strong>$table</strong></td><td>$count records</td></tr>";
        } catch (Exception $e) {
            echo "<tr><td><strong>$table</strong></td><td class='error'>Error</td></tr>";
        }
    }
    echo "</table>";
    
    echo "<p style='margin-top: 30px;'>";
    echo "<a href='../index.php' style='color: #4caf50; text-decoration: none;'>← Back to Dashboard</a>";
    echo "</p>";
    ?>
</body>
</html>
