<?php
/**
 * MultiCRM Sistem Kontrolü
 * Bu dosya sistem gereksinimlerini kontrol eder
 */

echo "<h2>MultiCRM Sistem Kontrolü</h2>";

// PHP versiyonu kontrolü
$phpVersion = phpversion();
echo "<p><strong>PHP Versiyonu:</strong> " . $phpVersion;
if (version_compare($phpVersion, '7.4.0', '>=')) {
    echo " <span style='color: green;'>✓</span>";
} else {
    echo " <span style='color: red;'>✗ (7.4+ gerekli)</span>";
}
echo "</p>";

// Gerekli PHP uzantıları
$requiredExtensions = ['pdo', 'pdo_mysql', 'curl', 'json', 'mbstring'];
echo "<p><strong>Gerekli PHP Uzantıları:</strong></p><ul>";
foreach ($requiredExtensions as $ext) {
    if (extension_loaded($ext)) {
        echo "<li style='color: green;'>✓ $ext</li>";
    } else {
        echo "<li style='color: red;'>✗ $ext (gerekli)</li>";
    }
}
echo "</ul>";

// Yazma izinleri
$writableDirs = ['logs', 'assets'];
echo "<p><strong>Yazma İzinleri:</strong></p><ul>";
foreach ($writableDirs as $dir) {
    if (is_dir($dir) && is_writable($dir)) {
        echo "<li style='color: green;'>✓ $dir dizini yazılabilir</li>";
    } else {
        echo "<li style='color: red;'>✗ $dir dizini yazılamıyor</li>";
    }
}
echo "</ul>";

// Veritabanı bağlantısı
echo "<p><strong>Veritabanı Bağlantısı:</strong> ";
try {
    $dsn = "mysql:host=localhost;charset=utf8mb4";
    $pdo = new PDO($dsn, 'profajco_multicrm', 'multi@@2025');
    echo "<span style='color: green;'>✓ Bağlantı başarılı</span>";
} catch (PDOException $e) {
    echo "<span style='color: red;'>✗ Bağlantı hatası: " . $e->getMessage() . "</span>";
}
echo "</p>";

// SSL kontrolü
echo "<p><strong>SSL Sertifikası:</strong> ";
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    echo "<span style='color: green;'>✓ HTTPS aktif</span>";
} else {
    echo "<span style='color: orange;'>⚠ HTTP (WhatsApp webhook için HTTPS gerekli)</span>";
}
echo "</p>";

// cURL testi
echo "<p><strong>cURL Testi:</strong> ";
if (function_exists('curl_init')) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode > 0) {
        echo "<span style='color: green;'>✓ cURL çalışıyor</span>";
    } else {
        echo "<span style='color: red;'>✗ cURL hatası</span>";
    }
} else {
    echo "<span style='color: red;'>✗ cURL yüklü değil</span>";
}
echo "</p>";

// Dosya boyutları
echo "<p><strong>PHP Ayarları:</strong></p><ul>";
echo "<li>upload_max_filesize: " . ini_get('upload_max_filesize') . "</li>";
echo "<li>post_max_size: " . ini_get('post_max_size') . "</li>";
echo "<li>max_execution_time: " . ini_get('max_execution_time') . " saniye</li>";
echo "<li>memory_limit: " . ini_get('memory_limit') . "</li>";
echo "</ul>";

echo "<hr>";
echo "<p><strong>Kurulum için:</strong> <a href='install.php'>install.php</a> dosyasını çalıştırın</p>";
?>
