<?php
/**
 * MultiCRM Kurulum Tamamlama
 * Bu dosya kurulum sonrası güvenlik ayarlarını yapar
 */

echo "<h2>MultiCRM Kurulum Tamamlandı!</h2>";

// Install dizinini koruma altına al
$htaccessContent = "Order Allow,Deny\nDeny from all";
file_put_contents('../install/.htaccess', $htaccessContent);

echo "<p>✓ Install dizini güvenlik altına alındı</p>";

// Log dizini izinlerini ayarla
if (is_dir('../logs')) {
    chmod('../logs', 0755);
    echo "<p>✓ Log dizini izinleri ayarlandı</p>";
}

// Varsayılan admin şifresini güncelle
echo "<div style='background: #f8f9fa; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";
echo "<h4>Güvenlik Uyarısı!</h4>";
echo "<p>Varsayılan admin şifresini değiştirmeyi unutmayın:</p>";
echo "<ul>";
echo "<li>Email: admin@multicrm.com</li>";
echo "<li>Şifre: password</li>";
echo "</ul>";
echo "<p><strong>Önemli:</strong> İlk girişten sonra şifrenizi mutlaka değiştirin!</p>";
echo "</div>";

echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";
echo "<h4>Kurulum Başarılı!</h4>";
echo "<p>MultiCRM sistemi başarıyla kuruldu. Şimdi aşağıdaki adımları takip edin:</p>";
echo "<ol>";
echo "<li><a href='../login.php'>Giriş yapın</a></li>";
echo "<li>WhatsApp API ayarlarını kontrol edin</li>";
echo "<li>Webhook URL'yi WhatsApp Developer Console'da ayarlayın</li>";
echo "<li>İlk müşterinizi ekleyin</li>";
echo "</ol>";
echo "</div>";

echo "<div style='background: #fff3cd; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";
echo "<h4>WhatsApp Webhook Ayarları</h4>";
echo "<p>WhatsApp Developer Console'da aşağıdaki bilgileri ayarlayın:</p>";
echo "<ul>";
echo "<li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "</ul>";
echo "</div>";

echo "<p><a href='../index.php' class='btn btn-primary'>Ana Sayfaya Git</a></p>";
?>
