<?php
/**
 * MultiCRM - cPanel Otomatik Kurulum
 * Bu dosya cPanel'de otomatik kurulum yapar
 */

echo "<h2>MultiCRM - cPanel Otomatik Kurulum</h2>";

// cPanel uyumluluk kontrolü
echo "<h3>1. Sistem Kontrolü</h3>";

$errors = [];
$warnings = [];

// PHP versiyonu kontrolü
$phpVersion = phpversion();
if (version_compare($phpVersion, '7.4.0', '<')) {
    $errors[] = "PHP 7.4+ gerekli (Mevcut: $phpVersion)";
}

// Gerekli uzantılar
$requiredExtensions = ['pdo', 'pdo_mysql', 'curl', 'json', 'mbstring'];
foreach ($requiredExtensions as $ext) {
    if (!extension_loaded($ext)) {
        $errors[] = "PHP uzantısı eksik: $ext";
    }
}

// SSL kontrolü
if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] !== 'on') {
    $warnings[] = "HTTPS aktif değil (WhatsApp webhook için gerekli)";
}

// Yazma izinleri
if (!is_writable('.')) {
    $errors[] = "Ana dizin yazılamıyor";
}

if (!is_dir('logs')) {
    mkdir('logs', 0755, true);
}

if (!is_writable('logs')) {
    $errors[] = "Logs dizini yazılamıyor";
}

// Hata kontrolü
if (!empty($errors)) {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24;'>";
    echo "<h4>❌ Kurulum Engellendi</h4>";
    echo "<ul>";
    foreach ($errors as $error) {
        echo "<li>$error</li>";
    }
    echo "</ul>";
    echo "</div>";
    exit();
}

// Uyarıları göster
if (!empty($warnings)) {
    echo "<div style='background: #fff3cd; padding: 1rem; border-radius: 5px; color: #856404;'>";
    echo "<h4>⚠️ Uyarılar</h4>";
    echo "<ul>";
    foreach ($warnings as $warning) {
        echo "<li>$warning</li>";
    }
    echo "</ul>";
    echo "</div>";
}

echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; color: #155724;'>";
echo "<h4>✅ Sistem Gereksinimleri Karşılanıyor</h4>";
echo "</div>";

// Veritabanı kurulumu
echo "<h3>2. Veritabanı Kurulumu</h3>";

try {
    // Veritabanı bağlantısı
    $dsn = "mysql:host=localhost;charset=utf8mb4";
    $pdo = new PDO($dsn, 'profajco_multicrm', 'multi@@2025');
    
    echo "<p>✓ Veritabanı bağlantısı başarılı</p>";
    
    // SQL dosyasını oku ve çalıştır
    $sqlFile = __DIR__ . '/database.sql';
    if (!file_exists($sqlFile)) {
        throw new Exception("database.sql dosyası bulunamadı!");
    }
    
    $sql = file_get_contents($sqlFile);
    $statements = explode(';', $sql);
    
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement)) {
            try {
                $pdo->exec($statement);
                $successCount++;
            } catch (PDOException $e) {
                // Bazı hatalar normal olabilir (tablo zaten var gibi)
                if (strpos($e->getMessage(), 'already exists') === false) {
                    $errorCount++;
                    echo "<p style='color: orange;'>⚠ SQL uyarısı: " . $e->getMessage() . "</p>";
                }
            }
        }
    }
    
    echo "<p>✓ Veritabanı kurulumu tamamlandı ($successCount başarılı, $errorCount uyarı)</p>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24;'>";
    echo "<h4>❌ Veritabanı Hatası</h4>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p><strong>Çözüm:</strong></p>";
    echo "<ol>";
    echo "<li>cPanel MySQL Database Wizard ile veritabanı oluşturun</li>";
    echo "<li>Database: profajco_multicrm</li>";
    echo "<li>Username: profajco_multicrm</li>";
    echo "<li>Password: multi@@2025</li>";
    echo "</ol>";
    echo "</div>";
    exit();
}

// Dosya izinleri ayarla
echo "<h3>3. Dosya İzinleri</h3>";

$directories = ['logs', 'assets'];
foreach ($directories as $dir) {
    if (is_dir($dir)) {
        chmod($dir, 0755);
        echo "<p>✓ $dir dizini izinleri ayarlandı</p>";
    }
}

// .htaccess dosyası oluştur
echo "<h3>4. Güvenlik Ayarları</h3>";

$htaccessContent = "# MultiCRM - Apache Yapılandırması

# PHP Ayarları
php_value upload_max_filesize 10M
php_value post_max_size 10M
php_value max_execution_time 300
php_value memory_limit 256M

# Güvenlik Ayarları
<Files \"*.sql\">
    Order Allow,Deny
    Deny from all
</Files>

<Files \"*.log\">
    Order Allow,Deny
    Deny from all
</Files>

# Log dizinini koru
<Directory \"logs\">
    Order Allow,Deny
    Deny from all
</Directory>

# Install dizinini koru (kurulum sonrası)
<Directory \"install\">
    Order Allow,Deny
    Deny from all
</Directory>

# URL Rewriting
RewriteEngine On

# HTTPS yönlendirmesi
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]

# Ana sayfa yönlendirmesi
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^$ index.php [L]

# Cache kontrolü
<IfModule mod_expires.c>
    ExpiresActive On
    ExpiresByType text/css \"access plus 1 month\"
    ExpiresByType application/javascript \"access plus 1 month\"
</IfModule>

# Gzip sıkıştırma
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/plain
    AddOutputFilterByType DEFLATE text/html
    AddOutputFilterByType DEFLATE text/css
    AddOutputFilterByType DEFLATE application/javascript
</IfModule>";

file_put_contents('../.htaccess', $htaccessContent);
echo "<p>✓ .htaccess dosyası oluşturuldu</p>";

// Install dizinini koru
file_put_contents('.htaccess', "Order Allow,Deny\nDeny from all");
echo "<p>✓ Install dizini güvenlik altına alındı</p>";

// WhatsApp webhook testi
echo "<h3>5. WhatsApp API Testi</h3>";

$whatsappConfig = [
    'phone_number_id' => '592915763902531',
    'access_token' => 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e',
    'api_version' => 'v18.0'
];

$testUrl = "https://graph.facebook.com/{$whatsappConfig['api_version']}/{$whatsappConfig['phone_number_id']}";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $whatsappConfig['access_token']
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200) {
    echo "<p>✓ WhatsApp API bağlantısı başarılı</p>";
} else {
    echo "<p style='color: orange;'>⚠ WhatsApp API testi başarısız (HTTP $httpCode)</p>";
    echo "<p>API token'ını kontrol edin</p>";
}

// Kurulum tamamlandı
echo "<h3>6. Kurulum Tamamlandı! 🎉</h3>";

echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; color: #155724;'>";
echo "<h4>✅ MultiCRM Başarıyla Kuruldu!</h4>";
echo "<p>Sistem cPanel'de çalışmaya hazır.</p>";
echo "</div>";

echo "<h4>📋 Sonraki Adımlar:</h4>";
echo "<ol>";
echo "<li><strong>Giriş Yapın:</strong> <a href='../login.php'>login.php</a></li>";
echo "<li><strong>Varsayılan Giriş:</strong> admin@multicrm.com / password</li>";
echo "<li><strong>WhatsApp Webhook:</strong> WhatsApp Developer Console'da ayarlayın</li>";
echo "<li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "</ol>";

echo "<h4>🔒 Güvenlik Uyarısı:</h4>";
echo "<div style='background: #fff3cd; padding: 1rem; border-radius: 5px; color: #856404;'>";
echo "<p><strong>Önemli:</strong> İlk girişten sonra admin şifresini değiştirin!</p>";
echo "<p>Varsayılan şifre: <code>password</code></p>";
echo "</div>";

echo "<p><a href='../index.php' class='btn btn-primary'>Ana Sayfaya Git</a></p>";
?>
