<?php
/**
 * Tüm Chatbot'ların Zamanlamasını Kapat
 */

require_once '../config/database.php';

echo "<h2>Chatbot Zamanlama Toplu Kapatma</h2>";

try {
    // Tüm chatbot'ların zamanlamasını kapat
    $stmt = $pdo->exec("UPDATE chatbots SET schedule_enabled = 0");
    
    echo "<p style='color: green;'>✅ Tüm chatbot'ların zamanlaması kapatıldı!</p>";
    echo "<p>Artık aktif olan chatbot her zaman AI yanıt verecek.</p>";
    
    // Güncel durumu göster
    $stmt = $pdo->query("SELECT id, name, is_active, schedule_enabled FROM chatbots");
    $chatbots = $stmt->fetchAll();
    
    echo "<h3>Güncel Durum:</h3>";
    echo "<table border='1' cellpadding='10'>";
    echo "<tr><th>ID</th><th>İsim</th><th>Aktif</th><th>Zamanlama</th></tr>";
    foreach ($chatbots as $bot) {
        $active = $bot['is_active'] ? '✅ Aktif' : '❌ Pasif';
        $schedule = $bot['schedule_enabled'] ? '⏰ Açık' : '🔓 Kapalı';
        echo "<tr>";
        echo "<td>{$bot['id']}</td>";
        echo "<td>{$bot['name']}</td>";
        echo "<td>{$active}</td>";
        echo "<td>{$schedule}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<hr>";
    echo "<p><strong>Artık hangi chatbot'u aktif ederseniz, AI her zaman cevap verecek!</strong></p>";
    echo "<p>Zamanlama istediğinizde Chatbot AI sayfasından açabilirsiniz.</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
}
?>
