<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $results = [];
    
    // Conversations tablosuna platform sütunu ekle
    try {
        $pdo->exec("ALTER TABLE conversations ADD COLUMN platform ENUM('whatsapp', 'facebook') DEFAULT 'whatsapp'");
        $results[] = ['success' => true, 'message' => 'Conversations tablosuna platform sütunu eklendi'];
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            $results[] = ['success' => true, 'message' => 'Platform sütunu zaten mevcut'];
        } else {
            $results[] = ['success' => false, 'message' => 'Platform sütunu eklenirken hata: ' . $e->getMessage()];
        }
    }
    
    // Customers tablosuna facebook_id sütunu ekle
    try {
        $pdo->exec("ALTER TABLE customers ADD COLUMN facebook_id VARCHAR(255) NULL");
        $results[] = ['success' => true, 'message' => 'Customers tablosuna facebook_id sütunu eklendi'];
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            $results[] = ['success' => true, 'message' => 'Facebook_id sütunu zaten mevcut'];
        } else {
            $results[] = ['success' => false, 'message' => 'Facebook_id sütunu eklenirken hata: ' . $e->getMessage()];
        }
    }
    
    // Messages tablosuna platform sütunu ekle
    try {
        $pdo->exec("ALTER TABLE messages ADD COLUMN platform ENUM('whatsapp', 'facebook') DEFAULT 'whatsapp'");
        $results[] = ['success' => true, 'message' => 'Messages tablosuna platform sütunu eklendi'];
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            $results[] = ['success' => true, 'message' => 'Platform sütunu zaten mevcut'];
        } else {
            $results[] = ['success' => false, 'message' => 'Platform sütunu eklenirken hata: ' . $e->getMessage()];
        }
    }
    
    // Index'leri ekle
    try {
        $pdo->exec("CREATE INDEX idx_conversations_platform ON conversations(platform)");
        $results[] = ['success' => true, 'message' => 'Conversations platform index\'i eklendi'];
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            $results[] = ['success' => true, 'message' => 'Platform index\'i zaten mevcut'];
        } else {
            $results[] = ['success' => false, 'message' => 'Platform index\'i eklenirken hata: ' . $e->getMessage()];
        }
    }
    
    try {
        $pdo->exec("CREATE INDEX idx_customers_facebook_id ON customers(facebook_id)");
        $results[] = ['success' => true, 'message' => 'Customers facebook_id index\'i eklendi'];
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            $results[] = ['success' => true, 'message' => 'Facebook_id index\'i zaten mevcut'];
        } else {
            $results[] = ['success' => false, 'message' => 'Facebook_id index\'i eklenirken hata: ' . $e->getMessage()];
        }
    }
    
    try {
        $pdo->exec("CREATE INDEX idx_messages_platform ON messages(platform)");
        $results[] = ['success' => true, 'message' => 'Messages platform index\'i eklendi'];
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            $results[] = ['success' => true, 'message' => 'Platform index\'i zaten mevcut'];
        } else {
            $results[] = ['success' => false, 'message' => 'Platform index\'i eklenirken hata: ' . $e->getMessage()];
        }
    }
    
    // Activity logs tablosu oluştur
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS activity_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT,
            action VARCHAR(255),
            details TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        )");
        $results[] = ['success' => true, 'message' => 'Activity logs tablosu oluşturuldu'];
    } catch (PDOException $e) {
        $results[] = ['success' => false, 'message' => 'Activity logs tablosu oluşturulurken hata: ' . $e->getMessage()];
    }
    
    echo json_encode([
        'success' => true,
        'results' => $results,
        'message' => 'Facebook entegrasyonu için veritabanı güncellemeleri tamamlandı'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Genel hata: ' . $e->getMessage()
    ]);
}
?>
