<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facebook Messenger Entegrasyonu Sihirbazı</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .wizard-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            margin: 50px auto;
            max-width: 800px;
        }
        .wizard-header {
            background: linear-gradient(135deg, #f97316 0%, #ff2400 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .wizard-content {
            padding: 40px;
        }
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
        }
        .step-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: #e2e8f0;
            margin: 0 10px;
            transition: all 0.3s ease;
        }
        .step-dot.active {
            background: #ff2400;
        }
        .step-dot.completed {
            background: #25d366;
        }
        .btn-primary {
            background: linear-gradient(135deg, #f97316 0%, #ff2400 100%);
            border: none;
            border-radius: 10px;
            padding: 12px 30px;
            font-weight: 600;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #ea580c 0%, #dc2626 100%);
            transform: translateY(-2px);
        }
        .form-control {
            border-radius: 10px;
            border: 2px solid #e2e8f0;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #ff2400;
            box-shadow: 0 0 0 0.2rem rgba(255, 36, 0, 0.25);
        }
        .alert {
            border-radius: 10px;
            border: none;
        }
        .success-icon {
            color: #25d366;
            font-size: 48px;
            margin-bottom: 20px;
        }
        .info-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin: 20px 0;
        }
        .code-block {
            background: #2d3748;
            color: #e2e8f0;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="wizard-container">
            <div class="wizard-header">
                <h2><i class="fab fa-facebook-messenger"></i> Facebook Messenger Entegrasyonu</h2>
                <p>MultiCRM sisteminize Facebook Messenger desteği ekleyin</p>
            </div>
            
            <div class="wizard-content">
                <!-- Step Indicator -->
                <div class="step-indicator">
                    <div class="step-dot active" id="step-1-dot"></div>
                    <div class="step-dot" id="step-2-dot"></div>
                    <div class="step-dot" id="step-3-dot"></div>
                    <div class="step-dot" id="step-4-dot"></div>
                </div>

                <!-- Step 1: Sistem Kontrolü -->
                <div class="step active" id="step-1">
                    <h4><i class="fas fa-cogs"></i> Sistem Kontrolü</h4>
                    <p>Facebook entegrasyonu için gerekli sistem kontrolleri yapılıyor...</p>
                    
                    <div id="system-checks">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>Hızlı Kontrol:</strong> Sistem dosyaları ve bağlantılar kontrol ediliyor...
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <button class="btn btn-primary" id="next-step-1">
                            <i class="fas fa-arrow-right"></i> Devam Et
                        </button>
                    </div>
                </div>

                <!-- Step 2: Veritabanı Güncellemeleri -->
                <div class="step" id="step-2">
                    <h4><i class="fas fa-database"></i> Veritabanı Güncellemeleri</h4>
                    <p>Facebook entegrasyonu için gerekli veritabanı güncellemeleri yapılacak.</p>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Önemli:</strong> Bu işlem veritabanınıza platform desteği ekleyecek. Mevcut verileriniz korunacak.
                    </div>
                    
                    <div id="database-updates">
                        <div class="text-center">
                            <button class="btn btn-primary" id="apply-updates-btn">
                                <i class="fas fa-database"></i> Veritabanı Güncellemelerini Uygula
                            </button>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <button class="btn btn-primary" id="next-step-2" disabled>
                            <i class="fas fa-arrow-right"></i> Devam Et
                        </button>
                    </div>
                </div>

                <!-- Step 3: Facebook Ayarları -->
                <div class="step" id="step-3">
                    <h4><i class="fab fa-facebook"></i> Facebook Developer Console Ayarları</h4>
                    <p>Facebook Developer Console'da aşağıdaki ayarları yapın:</p>
                    
                    <div class="info-card">
                        <h6><i class="fas fa-link"></i> Webhook URL:</h6>
                        <div class="code-block">https://profaj.co/multicrm/api/webhook-facebook.php</div>
                        
                        <h6><i class="fas fa-key"></i> Verify Token:</h6>
                        <div class="code-block">profaj_whatsapp_2024</div>
                        
                        <h6><i class="fas fa-list"></i> Abone Olunacak Alanlar:</h6>
                        <ul>
                            <li><strong>messages</strong> - Mesaj alımı için</li>
                            <li><strong>messaging_postbacks</strong> - Postback olayları için</li>
                        </ul>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Önemli:</strong> Facebook Developer Console'da webhook ayarlarını yaptıktan sonra "Devam Et" butonuna basın.
                    </div>
                    
                    <div class="text-center mt-4">
                        <button class="btn btn-primary" id="next-step-3">
                            <i class="fas fa-arrow-right"></i> Devam Et
                        </button>
                    </div>
                </div>

                <!-- Step 4: Tamamlandı -->
                <div class="step" id="step-4">
                    <div class="text-center">
                        <div class="success-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <h4>Facebook Entegrasyonu Tamamlandı!</h4>
                        <p>MultiCRM sisteminiz artık Facebook Messenger mesajlarını destekliyor.</p>
                        
                        <div class="info-card">
                            <h6><i class="fas fa-rocket"></i> Yeni Özellikler:</h6>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success"></i> Facebook Messenger mesaj alımı</li>
                                <li><i class="fas fa-check text-success"></i> Facebook Messenger mesaj gönderimi</li>
                                <li><i class="fas fa-check text-success"></i> Platform ayırımı (WhatsApp/Facebook)</li>
                                <li><i class="fas fa-check text-success"></i> Birleşik sohbet arayüzü</li>
                            </ul>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>Test:</strong> Facebook sayfanızdan bir mesaj göndererek entegrasyonun çalıştığını test edebilirsiniz.
                        </div>
                        
                        <div class="text-center mt-4">
                            <a href="../index.php" class="btn btn-primary">
                                <i class="fas fa-home"></i> Ana Sayfaya Git
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let currentStep = 1;
        const totalSteps = 4;

        // Step navigation
        function showStep(step) {
            // Hide all steps
            document.querySelectorAll('.step').forEach(s => s.classList.remove('active'));
            document.querySelectorAll('.step-dot').forEach(d => d.classList.remove('active'));
            
            // Show current step
            document.getElementById(`step-${step}`).classList.add('active');
            document.getElementById(`step-${step}-dot`).classList.add('active');
            
            // Mark previous steps as completed
            for (let i = 1; i < step; i++) {
                document.getElementById(`step-${i}-dot`).classList.add('completed');
            }
        }

        // Step 1: System checks - Otomatik başlat
        document.getElementById('next-step-1').addEventListener('click', () => {
            // Basit kontrol - dosyalar mevcut mu?
            const checksContainer = document.getElementById('system-checks');
            checksContainer.innerHTML = `
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <strong>Sistem Hazır:</strong> Facebook entegrasyonu için gerekli dosyalar mevcut.
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <span>Facebook webhook dosyası</span>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <span>Facebook send API dosyası</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <span>Config dosyası</span>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-check text-success me-2"></i>
                            <span>Veritabanı bağlantısı</span>
                        </div>
                    </div>
                </div>
            `;
            
            // Otomatik olarak 2. adıma geç
            setTimeout(() => {
                showStep(2);
                // 2. adımı da otomatik başlat
                setTimeout(() => {
                    document.getElementById('next-step-2').click();
                }, 500);
            }, 1500);
        });

        // Veritabanı güncellemelerini uygula butonu
        document.getElementById('apply-updates-btn').addEventListener('click', async () => {
            const updatesContainer = document.getElementById('database-updates');
            const applyBtn = document.getElementById('apply-updates-btn');
            
            // Butonu devre dışı bırak
            applyBtn.disabled = true;
            applyBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Güncellemeler uygulanıyor...';
            
            try {
                // Gerçek API çağrısı yap
                const response = await fetch('facebook-update-api.php');
                const result = await response.json();
                
                updatesContainer.innerHTML = '';
                
                if (result.success) {
                    result.results.forEach(update => {
                        const updateDiv = document.createElement('div');
                        updateDiv.className = 'd-flex align-items-center mb-3';
                        
                        const icon = document.createElement('div');
                        icon.className = update.success ? 'fas fa-check-circle text-success me-3' : 'fas fa-exclamation-circle text-danger me-3';
                        
                        const text = document.createElement('span');
                        text.textContent = update.message;
                        
                        updateDiv.appendChild(icon);
                        updateDiv.appendChild(text);
                        updatesContainer.appendChild(updateDiv);
                    });
                    
                    // Devam Et butonunu aktif et
                    document.getElementById('next-step-2').disabled = false;
                    
                } else {
                    updatesContainer.innerHTML = `
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-triangle"></i>
                            Veritabanı güncellemeleri sırasında hata oluştu: ${result.error}
                        </div>
                    `;
                }
            } catch (error) {
                updatesContainer.innerHTML = `
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle"></i>
                        API çağrısı sırasında hata oluştu: ${error.message}
                    </div>
                `;
            }
        });

        // Step 2: Database updates
        document.getElementById('next-step-2').addEventListener('click', () => {
            // 3. adıma geç
            showStep(3);
            // 3. adımı da otomatik başlat
            setTimeout(() => {
                document.getElementById('next-step-3').click();
            }, 500);
        });

        // Step 3: Facebook settings
        document.getElementById('next-step-3').addEventListener('click', () => {
            // 4. adıma geç
            setTimeout(() => {
                showStep(4);
            }, 1000);
        });

        // Initialize
        showStep(1);
    </script>
</body>
</html>
